package zio.aws.sagemaker.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sagemaker.model.primitives.{
  MaxAutoMLJobRuntimeInSeconds,
  MaxRuntimePerTrainingJobInSeconds,
  MaxCandidates
}
import scala.jdk.CollectionConverters._
final case class AutoMLJobCompletionCriteria(
    maxCandidates: Option[MaxCandidates] = None,
    maxRuntimePerTrainingJobInSeconds: Option[
      MaxRuntimePerTrainingJobInSeconds
    ] = None,
    maxAutoMLJobRuntimeInSeconds: Option[MaxAutoMLJobRuntimeInSeconds] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.AutoMLJobCompletionCriteria = {
    import AutoMLJobCompletionCriteria.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.AutoMLJobCompletionCriteria
      .builder()
      .optionallyWith(
        maxCandidates.map(value => MaxCandidates.unwrap(value): Integer)
      )(_.maxCandidates)
      .optionallyWith(
        maxRuntimePerTrainingJobInSeconds.map(value =>
          MaxRuntimePerTrainingJobInSeconds.unwrap(value): Integer
        )
      )(_.maxRuntimePerTrainingJobInSeconds)
      .optionallyWith(
        maxAutoMLJobRuntimeInSeconds.map(value =>
          MaxAutoMLJobRuntimeInSeconds.unwrap(value): Integer
        )
      )(_.maxAutoMLJobRuntimeInSeconds)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.AutoMLJobCompletionCriteria.ReadOnly =
    zio.aws.sagemaker.model.AutoMLJobCompletionCriteria.wrap(buildAwsValue())
}
object AutoMLJobCompletionCriteria {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.AutoMLJobCompletionCriteria
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.AutoMLJobCompletionCriteria =
      zio.aws.sagemaker.model.AutoMLJobCompletionCriteria(
        maxCandidates.map(value => value),
        maxRuntimePerTrainingJobInSeconds.map(value => value),
        maxAutoMLJobRuntimeInSeconds.map(value => value)
      )
    def maxCandidates: Option[MaxCandidates]
    def maxRuntimePerTrainingJobInSeconds
        : Option[MaxRuntimePerTrainingJobInSeconds]
    def maxAutoMLJobRuntimeInSeconds: Option[MaxAutoMLJobRuntimeInSeconds]
    def getMaxCandidates: ZIO[Any, AwsError, MaxCandidates] =
      AwsError.unwrapOptionField("maxCandidates", maxCandidates)
    def getMaxRuntimePerTrainingJobInSeconds
        : ZIO[Any, AwsError, MaxRuntimePerTrainingJobInSeconds] =
      AwsError.unwrapOptionField(
        "maxRuntimePerTrainingJobInSeconds",
        maxRuntimePerTrainingJobInSeconds
      )
    def getMaxAutoMLJobRuntimeInSeconds
        : ZIO[Any, AwsError, MaxAutoMLJobRuntimeInSeconds] =
      AwsError.unwrapOptionField(
        "maxAutoMLJobRuntimeInSeconds",
        maxAutoMLJobRuntimeInSeconds
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.AutoMLJobCompletionCriteria
  ) extends zio.aws.sagemaker.model.AutoMLJobCompletionCriteria.ReadOnly {
    override val maxCandidates: Option[MaxCandidates] = scala
      .Option(impl.maxCandidates())
      .map(value => zio.aws.sagemaker.model.primitives.MaxCandidates(value))
    override val maxRuntimePerTrainingJobInSeconds
        : Option[MaxRuntimePerTrainingJobInSeconds] = scala
      .Option(impl.maxRuntimePerTrainingJobInSeconds())
      .map(value =>
        zio.aws.sagemaker.model.primitives
          .MaxRuntimePerTrainingJobInSeconds(value)
      )
    override val maxAutoMLJobRuntimeInSeconds
        : Option[MaxAutoMLJobRuntimeInSeconds] = scala
      .Option(impl.maxAutoMLJobRuntimeInSeconds())
      .map(value =>
        zio.aws.sagemaker.model.primitives.MaxAutoMLJobRuntimeInSeconds(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.AutoMLJobCompletionCriteria
  ): zio.aws.sagemaker.model.AutoMLJobCompletionCriteria.ReadOnly = new Wrapper(
    impl
  )
}
