package zio.aws.sagemaker.model
import scala.jdk.CollectionConverters._
sealed trait AthenaResultFormat {
  def unwrap: software.amazon.awssdk.services.sagemaker.model.AthenaResultFormat
}
object AthenaResultFormat {
  def wrap(
      value: software.amazon.awssdk.services.sagemaker.model.AthenaResultFormat
  ): zio.aws.sagemaker.model.AthenaResultFormat = value match {
    case software.amazon.awssdk.services.sagemaker.model.AthenaResultFormat.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sagemaker.model.AthenaResultFormat.PARQUET =>
      val r = PARQUET
      r
    case software.amazon.awssdk.services.sagemaker.model.AthenaResultFormat.ORC =>
      val r = ORC
      r
    case software.amazon.awssdk.services.sagemaker.model.AthenaResultFormat.AVRO =>
      val r = AVRO
      r
    case software.amazon.awssdk.services.sagemaker.model.AthenaResultFormat.JSON =>
      val r = JSON
      r
    case software.amazon.awssdk.services.sagemaker.model.AthenaResultFormat.TEXTFILE =>
      val r = TEXTFILE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.sagemaker.model.AthenaResultFormat {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.AthenaResultFormat =
      software.amazon.awssdk.services.sagemaker.model.AthenaResultFormat.UNKNOWN_TO_SDK_VERSION
  }
  case object PARQUET extends zio.aws.sagemaker.model.AthenaResultFormat {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.AthenaResultFormat =
      software.amazon.awssdk.services.sagemaker.model.AthenaResultFormat.PARQUET
  }
  case object ORC extends zio.aws.sagemaker.model.AthenaResultFormat {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.AthenaResultFormat =
      software.amazon.awssdk.services.sagemaker.model.AthenaResultFormat.ORC
  }
  case object AVRO extends zio.aws.sagemaker.model.AthenaResultFormat {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.AthenaResultFormat =
      software.amazon.awssdk.services.sagemaker.model.AthenaResultFormat.AVRO
  }
  case object JSON extends zio.aws.sagemaker.model.AthenaResultFormat {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.AthenaResultFormat =
      software.amazon.awssdk.services.sagemaker.model.AthenaResultFormat.JSON
  }
  case object TEXTFILE extends zio.aws.sagemaker.model.AthenaResultFormat {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.AthenaResultFormat =
      software.amazon.awssdk.services.sagemaker.model.AthenaResultFormat.TEXTFILE
  }
}
