package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.ExperimentEntityName
import scala.jdk.CollectionConverters._
final case class AssociateTrialComponentRequest(
    trialComponentName: ExperimentEntityName,
    trialName: ExperimentEntityName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.AssociateTrialComponentRequest = {
    import AssociateTrialComponentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.AssociateTrialComponentRequest
      .builder()
      .trialComponentName(
        ExperimentEntityName.unwrap(trialComponentName): java.lang.String
      )
      .trialName(ExperimentEntityName.unwrap(trialName): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.AssociateTrialComponentRequest.ReadOnly =
    zio.aws.sagemaker.model.AssociateTrialComponentRequest.wrap(buildAwsValue())
}
object AssociateTrialComponentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.AssociateTrialComponentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.AssociateTrialComponentRequest =
      zio.aws.sagemaker.model
        .AssociateTrialComponentRequest(trialComponentName, trialName)
    def trialComponentName: ExperimentEntityName
    def trialName: ExperimentEntityName
    def getTrialComponentName: ZIO[Any, Nothing, ExperimentEntityName] =
      ZIO.succeed(trialComponentName)
    def getTrialName: ZIO[Any, Nothing, ExperimentEntityName] =
      ZIO.succeed(trialName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.AssociateTrialComponentRequest
  ) extends zio.aws.sagemaker.model.AssociateTrialComponentRequest.ReadOnly {
    override val trialComponentName: ExperimentEntityName =
      zio.aws.sagemaker.model.primitives
        .ExperimentEntityName(impl.trialComponentName())
    override val trialName: ExperimentEntityName =
      zio.aws.sagemaker.model.primitives.ExperimentEntityName(impl.trialName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.AssociateTrialComponentRequest
  ): zio.aws.sagemaker.model.AssociateTrialComponentRequest.ReadOnly =
    new Wrapper(impl)
}
