package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sagemaker.model.primitives.AssociationEntityArn
import scala.jdk.CollectionConverters._
final case class AddAssociationRequest(
    sourceArn: AssociationEntityArn,
    destinationArn: AssociationEntityArn,
    associationType: Option[zio.aws.sagemaker.model.AssociationEdgeType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.AddAssociationRequest = {
    import AddAssociationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.AddAssociationRequest
      .builder()
      .sourceArn(AssociationEntityArn.unwrap(sourceArn): java.lang.String)
      .destinationArn(
        AssociationEntityArn.unwrap(destinationArn): java.lang.String
      )
      .optionallyWith(associationType.map(value => value.unwrap))(
        _.associationType
      )
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.AddAssociationRequest.ReadOnly =
    zio.aws.sagemaker.model.AddAssociationRequest.wrap(buildAwsValue())
}
object AddAssociationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.AddAssociationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.AddAssociationRequest =
      zio.aws.sagemaker.model.AddAssociationRequest(
        sourceArn,
        destinationArn,
        associationType.map(value => value)
      )
    def sourceArn: AssociationEntityArn
    def destinationArn: AssociationEntityArn
    def associationType: Option[zio.aws.sagemaker.model.AssociationEdgeType]
    def getSourceArn: ZIO[Any, Nothing, AssociationEntityArn] =
      ZIO.succeed(sourceArn)
    def getDestinationArn: ZIO[Any, Nothing, AssociationEntityArn] =
      ZIO.succeed(destinationArn)
    def getAssociationType
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.AssociationEdgeType] =
      AwsError.unwrapOptionField("associationType", associationType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.AddAssociationRequest
  ) extends zio.aws.sagemaker.model.AddAssociationRequest.ReadOnly {
    override val sourceArn: AssociationEntityArn =
      zio.aws.sagemaker.model.primitives.AssociationEntityArn(impl.sourceArn())
    override val destinationArn: AssociationEntityArn =
      zio.aws.sagemaker.model.primitives
        .AssociationEntityArn(impl.destinationArn())
    override val associationType
        : Option[zio.aws.sagemaker.model.AssociationEdgeType] = scala
      .Option(impl.associationType())
      .map(value => zio.aws.sagemaker.model.AssociationEdgeType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.AddAssociationRequest
  ): zio.aws.sagemaker.model.AddAssociationRequest.ReadOnly = new Wrapper(impl)
}
