package zio.aws.sagemaker.model
import scala.jdk.CollectionConverters._
sealed trait UserProfileStatus {
  def unwrap: software.amazon.awssdk.services.sagemaker.model.UserProfileStatus
}
object UserProfileStatus {
  def wrap(
      value: software.amazon.awssdk.services.sagemaker.model.UserProfileStatus
  ): zio.aws.sagemaker.model.UserProfileStatus = value match {
    case software.amazon.awssdk.services.sagemaker.model.UserProfileStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sagemaker.model.UserProfileStatus.DELETING =>
      val r = Deleting
      r
    case software.amazon.awssdk.services.sagemaker.model.UserProfileStatus.FAILED =>
      val r = Failed
      r
    case software.amazon.awssdk.services.sagemaker.model.UserProfileStatus.IN_SERVICE =>
      val r = InService
      r
    case software.amazon.awssdk.services.sagemaker.model.UserProfileStatus.PENDING =>
      val r = Pending
      r
    case software.amazon.awssdk.services.sagemaker.model.UserProfileStatus.UPDATING =>
      val r = Updating
      r
    case software.amazon.awssdk.services.sagemaker.model.UserProfileStatus.UPDATE_FAILED =>
      val r = Update_Failed
      r
    case software.amazon.awssdk.services.sagemaker.model.UserProfileStatus.DELETE_FAILED =>
      val r = Delete_Failed
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.sagemaker.model.UserProfileStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.UserProfileStatus =
      software.amazon.awssdk.services.sagemaker.model.UserProfileStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object Deleting extends zio.aws.sagemaker.model.UserProfileStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.UserProfileStatus =
      software.amazon.awssdk.services.sagemaker.model.UserProfileStatus.DELETING
  }
  case object Failed extends zio.aws.sagemaker.model.UserProfileStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.UserProfileStatus =
      software.amazon.awssdk.services.sagemaker.model.UserProfileStatus.FAILED
  }
  case object InService extends zio.aws.sagemaker.model.UserProfileStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.UserProfileStatus =
      software.amazon.awssdk.services.sagemaker.model.UserProfileStatus.IN_SERVICE
  }
  case object Pending extends zio.aws.sagemaker.model.UserProfileStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.UserProfileStatus =
      software.amazon.awssdk.services.sagemaker.model.UserProfileStatus.PENDING
  }
  case object Updating extends zio.aws.sagemaker.model.UserProfileStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.UserProfileStatus =
      software.amazon.awssdk.services.sagemaker.model.UserProfileStatus.UPDATING
  }
  case object Update_Failed extends zio.aws.sagemaker.model.UserProfileStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.UserProfileStatus =
      software.amazon.awssdk.services.sagemaker.model.UserProfileStatus.UPDATE_FAILED
  }
  case object Delete_Failed extends zio.aws.sagemaker.model.UserProfileStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.UserProfileStatus =
      software.amazon.awssdk.services.sagemaker.model.UserProfileStatus.DELETE_FAILED
  }
}
