package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class TrafficPattern(
    trafficType: Option[zio.aws.sagemaker.model.TrafficType] = None,
    phases: Option[Iterable[zio.aws.sagemaker.model.Phase]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.TrafficPattern = {
    import TrafficPattern.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.TrafficPattern
      .builder()
      .optionallyWith(trafficType.map(value => value.unwrap))(_.trafficType)
      .optionallyWith(
        phases.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.phases)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.TrafficPattern.ReadOnly =
    zio.aws.sagemaker.model.TrafficPattern.wrap(buildAwsValue())
}
object TrafficPattern {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.TrafficPattern
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.TrafficPattern =
      zio.aws.sagemaker.model.TrafficPattern(
        trafficType.map(value => value),
        phases.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def trafficType: Option[zio.aws.sagemaker.model.TrafficType]
    def phases: Option[List[zio.aws.sagemaker.model.Phase.ReadOnly]]
    def getTrafficType
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.TrafficType] =
      AwsError.unwrapOptionField("trafficType", trafficType)
    def getPhases
        : ZIO[Any, AwsError, List[zio.aws.sagemaker.model.Phase.ReadOnly]] =
      AwsError.unwrapOptionField("phases", phases)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.TrafficPattern
  ) extends zio.aws.sagemaker.model.TrafficPattern.ReadOnly {
    override val trafficType: Option[zio.aws.sagemaker.model.TrafficType] =
      scala
        .Option(impl.trafficType())
        .map(value => zio.aws.sagemaker.model.TrafficType.wrap(value))
    override val phases: Option[List[zio.aws.sagemaker.model.Phase.ReadOnly]] =
      scala
        .Option(impl.phases())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sagemaker.model.Phase.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.TrafficPattern
  ): zio.aws.sagemaker.model.TrafficPattern.ReadOnly = new Wrapper(impl)
}
