package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sagemaker.model.primitives.{S3Uri, DirectoryPath}
import scala.jdk.CollectionConverters._
final case class TensorBoardOutputConfig(
    localPath: Option[DirectoryPath] = None,
    s3OutputPath: S3Uri
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.TensorBoardOutputConfig = {
    import TensorBoardOutputConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.TensorBoardOutputConfig
      .builder()
      .optionallyWith(
        localPath.map(value => DirectoryPath.unwrap(value): java.lang.String)
      )(_.localPath)
      .s3OutputPath(S3Uri.unwrap(s3OutputPath): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.TensorBoardOutputConfig.ReadOnly =
    zio.aws.sagemaker.model.TensorBoardOutputConfig.wrap(buildAwsValue())
}
object TensorBoardOutputConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.TensorBoardOutputConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.TensorBoardOutputConfig =
      zio.aws.sagemaker.model
        .TensorBoardOutputConfig(localPath.map(value => value), s3OutputPath)
    def localPath: Option[DirectoryPath]
    def s3OutputPath: S3Uri
    def getLocalPath: ZIO[Any, AwsError, DirectoryPath] =
      AwsError.unwrapOptionField("localPath", localPath)
    def getS3OutputPath: ZIO[Any, Nothing, S3Uri] = ZIO.succeed(s3OutputPath)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.TensorBoardOutputConfig
  ) extends zio.aws.sagemaker.model.TensorBoardOutputConfig.ReadOnly {
    override val localPath: Option[DirectoryPath] = scala
      .Option(impl.localPath())
      .map(value => zio.aws.sagemaker.model.primitives.DirectoryPath(value))
    override val s3OutputPath: S3Uri =
      zio.aws.sagemaker.model.primitives.S3Uri(impl.s3OutputPath())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.TensorBoardOutputConfig
  ): zio.aws.sagemaker.model.TensorBoardOutputConfig.ReadOnly = new Wrapper(
    impl
  )
}
