package zio.aws.sagemaker.model
import scala.jdk.CollectionConverters._
sealed trait StepStatus {
  def unwrap: software.amazon.awssdk.services.sagemaker.model.StepStatus
}
object StepStatus {
  def wrap(
      value: software.amazon.awssdk.services.sagemaker.model.StepStatus
  ): zio.aws.sagemaker.model.StepStatus = value match {
    case software.amazon.awssdk.services.sagemaker.model.StepStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sagemaker.model.StepStatus.STARTING =>
      val r = Starting
      r
    case software.amazon.awssdk.services.sagemaker.model.StepStatus.EXECUTING =>
      val r = Executing
      r
    case software.amazon.awssdk.services.sagemaker.model.StepStatus.STOPPING =>
      val r = Stopping
      r
    case software.amazon.awssdk.services.sagemaker.model.StepStatus.STOPPED =>
      val r = Stopped
      r
    case software.amazon.awssdk.services.sagemaker.model.StepStatus.FAILED =>
      val r = Failed
      r
    case software.amazon.awssdk.services.sagemaker.model.StepStatus.SUCCEEDED =>
      val r = Succeeded
      r
  }
  case object unknownToSdkVersion extends zio.aws.sagemaker.model.StepStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.StepStatus =
      software.amazon.awssdk.services.sagemaker.model.StepStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object Starting extends zio.aws.sagemaker.model.StepStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.StepStatus =
      software.amazon.awssdk.services.sagemaker.model.StepStatus.STARTING
  }
  case object Executing extends zio.aws.sagemaker.model.StepStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.StepStatus =
      software.amazon.awssdk.services.sagemaker.model.StepStatus.EXECUTING
  }
  case object Stopping extends zio.aws.sagemaker.model.StepStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.StepStatus =
      software.amazon.awssdk.services.sagemaker.model.StepStatus.STOPPING
  }
  case object Stopped extends zio.aws.sagemaker.model.StepStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.StepStatus =
      software.amazon.awssdk.services.sagemaker.model.StepStatus.STOPPED
  }
  case object Failed extends zio.aws.sagemaker.model.StepStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.StepStatus =
      software.amazon.awssdk.services.sagemaker.model.StepStatus.FAILED
  }
  case object Succeeded extends zio.aws.sagemaker.model.StepStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.StepStatus =
      software.amazon.awssdk.services.sagemaker.model.StepStatus.SUCCEEDED
  }
}
