package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sagemaker.model.primitives.PipelineExecutionArn
import scala.jdk.CollectionConverters._
final case class SendPipelineExecutionStepFailureResponse(
    pipelineExecutionArn: Option[PipelineExecutionArn] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.SendPipelineExecutionStepFailureResponse = {
    import SendPipelineExecutionStepFailureResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.SendPipelineExecutionStepFailureResponse
      .builder()
      .optionallyWith(
        pipelineExecutionArn.map(value =>
          PipelineExecutionArn.unwrap(value): java.lang.String
        )
      )(_.pipelineExecutionArn)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.SendPipelineExecutionStepFailureResponse.ReadOnly =
    zio.aws.sagemaker.model.SendPipelineExecutionStepFailureResponse
      .wrap(buildAwsValue())
}
object SendPipelineExecutionStepFailureResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.SendPipelineExecutionStepFailureResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.sagemaker.model.SendPipelineExecutionStepFailureResponse =
      zio.aws.sagemaker.model.SendPipelineExecutionStepFailureResponse(
        pipelineExecutionArn.map(value => value)
      )
    def pipelineExecutionArn: Option[PipelineExecutionArn]
    def getPipelineExecutionArn: ZIO[Any, AwsError, PipelineExecutionArn] =
      AwsError.unwrapOptionField("pipelineExecutionArn", pipelineExecutionArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.SendPipelineExecutionStepFailureResponse
  ) extends zio.aws.sagemaker.model.SendPipelineExecutionStepFailureResponse.ReadOnly {
    override val pipelineExecutionArn: Option[PipelineExecutionArn] = scala
      .Option(impl.pipelineExecutionArn())
      .map(value =>
        zio.aws.sagemaker.model.primitives.PipelineExecutionArn(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.SendPipelineExecutionStepFailureResponse
  ): zio.aws.sagemaker.model.SendPipelineExecutionStepFailureResponse.ReadOnly =
    new Wrapper(impl)
}
