package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class SearchExpression(
    filters: Option[Iterable[zio.aws.sagemaker.model.Filter]] = None,
    nestedFilters: Option[Iterable[zio.aws.sagemaker.model.NestedFilters]] =
      None,
    subExpressions: Option[Iterable[zio.aws.sagemaker.model.SearchExpression]] =
      None,
    operator: Option[zio.aws.sagemaker.model.BooleanOperator] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.SearchExpression = {
    import SearchExpression.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.SearchExpression
      .builder()
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(
        nestedFilters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.nestedFilters)
      .optionallyWith(
        subExpressions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.subExpressions)
      .optionallyWith(operator.map(value => value.unwrap))(_.operator)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.SearchExpression.ReadOnly =
    zio.aws.sagemaker.model.SearchExpression.wrap(buildAwsValue())
}
object SearchExpression {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.SearchExpression
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.SearchExpression =
      zio.aws.sagemaker.model.SearchExpression(
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nestedFilters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        subExpressions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        operator.map(value => value)
      )
    def filters: Option[List[zio.aws.sagemaker.model.Filter.ReadOnly]]
    def nestedFilters
        : Option[List[zio.aws.sagemaker.model.NestedFilters.ReadOnly]]
    def subExpressions
        : Option[List[zio.aws.sagemaker.model.SearchExpression.ReadOnly]]
    def operator: Option[zio.aws.sagemaker.model.BooleanOperator]
    def getFilters
        : ZIO[Any, AwsError, List[zio.aws.sagemaker.model.Filter.ReadOnly]] =
      AwsError.unwrapOptionField("filters", filters)
    def getNestedFilters: ZIO[Any, AwsError, List[
      zio.aws.sagemaker.model.NestedFilters.ReadOnly
    ]] = AwsError.unwrapOptionField("nestedFilters", nestedFilters)
    def getSubExpressions: ZIO[Any, AwsError, List[
      zio.aws.sagemaker.model.SearchExpression.ReadOnly
    ]] = AwsError.unwrapOptionField("subExpressions", subExpressions)
    def getOperator
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.BooleanOperator] =
      AwsError.unwrapOptionField("operator", operator)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.SearchExpression
  ) extends zio.aws.sagemaker.model.SearchExpression.ReadOnly {
    override val filters
        : Option[List[zio.aws.sagemaker.model.Filter.ReadOnly]] = scala
      .Option(impl.filters())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.sagemaker.model.Filter.wrap(item)
        }.toList
      )
    override val nestedFilters
        : Option[List[zio.aws.sagemaker.model.NestedFilters.ReadOnly]] = scala
      .Option(impl.nestedFilters())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.sagemaker.model.NestedFilters.wrap(item)
        }.toList
      )
    override val subExpressions
        : Option[List[zio.aws.sagemaker.model.SearchExpression.ReadOnly]] =
      scala
        .Option(impl.subExpressions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sagemaker.model.SearchExpression.wrap(item)
          }.toList
        )
    override val operator: Option[zio.aws.sagemaker.model.BooleanOperator] =
      scala
        .Option(impl.operator())
        .map(value => zio.aws.sagemaker.model.BooleanOperator.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.SearchExpression
  ): zio.aws.sagemaker.model.SearchExpression.ReadOnly = new Wrapper(impl)
}
