package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.sagemaker.model.primitives.{Timestamp, VariantStatusMessage}
import scala.jdk.CollectionConverters._
final case class ProductionVariantStatus(
    status: zio.aws.sagemaker.model.VariantStatus,
    statusMessage: Option[VariantStatusMessage] = None,
    startTime: Option[Timestamp] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ProductionVariantStatus = {
    import ProductionVariantStatus.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ProductionVariantStatus
      .builder()
      .status(status.unwrap)
      .optionallyWith(
        statusMessage.map(value =>
          VariantStatusMessage.unwrap(value): java.lang.String
        )
      )(_.statusMessage)
      .optionallyWith(startTime.map(value => Timestamp.unwrap(value): Instant))(
        _.startTime
      )
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.ProductionVariantStatus.ReadOnly =
    zio.aws.sagemaker.model.ProductionVariantStatus.wrap(buildAwsValue())
}
object ProductionVariantStatus {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ProductionVariantStatus
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ProductionVariantStatus =
      zio.aws.sagemaker.model.ProductionVariantStatus(
        status,
        statusMessage.map(value => value),
        startTime.map(value => value)
      )
    def status: zio.aws.sagemaker.model.VariantStatus
    def statusMessage: Option[VariantStatusMessage]
    def startTime: Option[Timestamp]
    def getStatus: ZIO[Any, Nothing, zio.aws.sagemaker.model.VariantStatus] =
      ZIO.succeed(status)
    def getStatusMessage: ZIO[Any, AwsError, VariantStatusMessage] =
      AwsError.unwrapOptionField("statusMessage", statusMessage)
    def getStartTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("startTime", startTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ProductionVariantStatus
  ) extends zio.aws.sagemaker.model.ProductionVariantStatus.ReadOnly {
    override val status: zio.aws.sagemaker.model.VariantStatus =
      zio.aws.sagemaker.model.VariantStatus.wrap(impl.status())
    override val statusMessage: Option[VariantStatusMessage] = scala
      .Option(impl.statusMessage())
      .map(value =>
        zio.aws.sagemaker.model.primitives.VariantStatusMessage(value)
      )
    override val startTime: Option[Timestamp] = scala
      .Option(impl.startTime())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ProductionVariantStatus
  ): zio.aws.sagemaker.model.ProductionVariantStatus.ReadOnly = new Wrapper(
    impl
  )
}
