package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sagemaker.model.primitives.{S3Uri, KmsKeyId}
import scala.jdk.CollectionConverters._
final case class OutputDataConfig(
    kmsKeyId: Option[KmsKeyId] = None,
    s3OutputPath: S3Uri
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.OutputDataConfig = {
    import OutputDataConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.OutputDataConfig
      .builder()
      .optionallyWith(
        kmsKeyId.map(value => KmsKeyId.unwrap(value): java.lang.String)
      )(_.kmsKeyId)
      .s3OutputPath(S3Uri.unwrap(s3OutputPath): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.OutputDataConfig.ReadOnly =
    zio.aws.sagemaker.model.OutputDataConfig.wrap(buildAwsValue())
}
object OutputDataConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.OutputDataConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.OutputDataConfig =
      zio.aws.sagemaker.model
        .OutputDataConfig(kmsKeyId.map(value => value), s3OutputPath)
    def kmsKeyId: Option[KmsKeyId]
    def s3OutputPath: S3Uri
    def getKmsKeyId: ZIO[Any, AwsError, KmsKeyId] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getS3OutputPath: ZIO[Any, Nothing, S3Uri] = ZIO.succeed(s3OutputPath)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.OutputDataConfig
  ) extends zio.aws.sagemaker.model.OutputDataConfig.ReadOnly {
    override val kmsKeyId: Option[KmsKeyId] = scala
      .Option(impl.kmsKeyId())
      .map(value => zio.aws.sagemaker.model.primitives.KmsKeyId(value))
    override val s3OutputPath: S3Uri =
      zio.aws.sagemaker.model.primitives.S3Uri(impl.s3OutputPath())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.OutputDataConfig
  ): zio.aws.sagemaker.model.OutputDataConfig.ReadOnly = new Wrapper(impl)
}
