package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sagemaker.model.primitives.{OidcEndpoint, ClientId}
import scala.jdk.CollectionConverters._
final case class OidcConfigForResponse(
    clientId: Option[ClientId] = None,
    issuer: Option[OidcEndpoint] = None,
    authorizationEndpoint: Option[OidcEndpoint] = None,
    tokenEndpoint: Option[OidcEndpoint] = None,
    userInfoEndpoint: Option[OidcEndpoint] = None,
    logoutEndpoint: Option[OidcEndpoint] = None,
    jwksUri: Option[OidcEndpoint] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.OidcConfigForResponse = {
    import OidcConfigForResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.OidcConfigForResponse
      .builder()
      .optionallyWith(
        clientId.map(value => ClientId.unwrap(value): java.lang.String)
      )(_.clientId)
      .optionallyWith(
        issuer.map(value => OidcEndpoint.unwrap(value): java.lang.String)
      )(_.issuer)
      .optionallyWith(
        authorizationEndpoint.map(value =>
          OidcEndpoint.unwrap(value): java.lang.String
        )
      )(_.authorizationEndpoint)
      .optionallyWith(
        tokenEndpoint.map(value => OidcEndpoint.unwrap(value): java.lang.String)
      )(_.tokenEndpoint)
      .optionallyWith(
        userInfoEndpoint.map(value =>
          OidcEndpoint.unwrap(value): java.lang.String
        )
      )(_.userInfoEndpoint)
      .optionallyWith(
        logoutEndpoint.map(value =>
          OidcEndpoint.unwrap(value): java.lang.String
        )
      )(_.logoutEndpoint)
      .optionallyWith(
        jwksUri.map(value => OidcEndpoint.unwrap(value): java.lang.String)
      )(_.jwksUri)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.OidcConfigForResponse.ReadOnly =
    zio.aws.sagemaker.model.OidcConfigForResponse.wrap(buildAwsValue())
}
object OidcConfigForResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.OidcConfigForResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.OidcConfigForResponse =
      zio.aws.sagemaker.model.OidcConfigForResponse(
        clientId.map(value => value),
        issuer.map(value => value),
        authorizationEndpoint.map(value => value),
        tokenEndpoint.map(value => value),
        userInfoEndpoint.map(value => value),
        logoutEndpoint.map(value => value),
        jwksUri.map(value => value)
      )
    def clientId: Option[ClientId]
    def issuer: Option[OidcEndpoint]
    def authorizationEndpoint: Option[OidcEndpoint]
    def tokenEndpoint: Option[OidcEndpoint]
    def userInfoEndpoint: Option[OidcEndpoint]
    def logoutEndpoint: Option[OidcEndpoint]
    def jwksUri: Option[OidcEndpoint]
    def getClientId: ZIO[Any, AwsError, ClientId] =
      AwsError.unwrapOptionField("clientId", clientId)
    def getIssuer: ZIO[Any, AwsError, OidcEndpoint] =
      AwsError.unwrapOptionField("issuer", issuer)
    def getAuthorizationEndpoint: ZIO[Any, AwsError, OidcEndpoint] =
      AwsError.unwrapOptionField("authorizationEndpoint", authorizationEndpoint)
    def getTokenEndpoint: ZIO[Any, AwsError, OidcEndpoint] =
      AwsError.unwrapOptionField("tokenEndpoint", tokenEndpoint)
    def getUserInfoEndpoint: ZIO[Any, AwsError, OidcEndpoint] =
      AwsError.unwrapOptionField("userInfoEndpoint", userInfoEndpoint)
    def getLogoutEndpoint: ZIO[Any, AwsError, OidcEndpoint] =
      AwsError.unwrapOptionField("logoutEndpoint", logoutEndpoint)
    def getJwksUri: ZIO[Any, AwsError, OidcEndpoint] =
      AwsError.unwrapOptionField("jwksUri", jwksUri)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.OidcConfigForResponse
  ) extends zio.aws.sagemaker.model.OidcConfigForResponse.ReadOnly {
    override val clientId: Option[ClientId] = scala
      .Option(impl.clientId())
      .map(value => zio.aws.sagemaker.model.primitives.ClientId(value))
    override val issuer: Option[OidcEndpoint] = scala
      .Option(impl.issuer())
      .map(value => zio.aws.sagemaker.model.primitives.OidcEndpoint(value))
    override val authorizationEndpoint: Option[OidcEndpoint] = scala
      .Option(impl.authorizationEndpoint())
      .map(value => zio.aws.sagemaker.model.primitives.OidcEndpoint(value))
    override val tokenEndpoint: Option[OidcEndpoint] = scala
      .Option(impl.tokenEndpoint())
      .map(value => zio.aws.sagemaker.model.primitives.OidcEndpoint(value))
    override val userInfoEndpoint: Option[OidcEndpoint] = scala
      .Option(impl.userInfoEndpoint())
      .map(value => zio.aws.sagemaker.model.primitives.OidcEndpoint(value))
    override val logoutEndpoint: Option[OidcEndpoint] = scala
      .Option(impl.logoutEndpoint())
      .map(value => zio.aws.sagemaker.model.primitives.OidcEndpoint(value))
    override val jwksUri: Option[OidcEndpoint] = scala
      .Option(impl.jwksUri())
      .map(value => zio.aws.sagemaker.model.primitives.OidcEndpoint(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.OidcConfigForResponse
  ): zio.aws.sagemaker.model.OidcConfigForResponse.ReadOnly = new Wrapper(impl)
}
