package zio.aws.sagemaker.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sagemaker.model.primitives.{
  MaxResults,
  NextToken,
  PipelineExecutionArn
}
import scala.jdk.CollectionConverters._
final case class ListPipelineParametersForExecutionRequest(
    pipelineExecutionArn: PipelineExecutionArn,
    nextToken: Option[NextToken] = None,
    maxResults: Option[MaxResults] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ListPipelineParametersForExecutionRequest = {
    import ListPipelineParametersForExecutionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ListPipelineParametersForExecutionRequest
      .builder()
      .pipelineExecutionArn(
        PipelineExecutionArn.unwrap(pipelineExecutionArn): java.lang.String
      )
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.ListPipelineParametersForExecutionRequest.ReadOnly =
    zio.aws.sagemaker.model.ListPipelineParametersForExecutionRequest
      .wrap(buildAwsValue())
}
object ListPipelineParametersForExecutionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ListPipelineParametersForExecutionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.sagemaker.model.ListPipelineParametersForExecutionRequest =
      zio.aws.sagemaker.model.ListPipelineParametersForExecutionRequest(
        pipelineExecutionArn,
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def pipelineExecutionArn: PipelineExecutionArn
    def nextToken: Option[NextToken]
    def maxResults: Option[MaxResults]
    def getPipelineExecutionArn: ZIO[Any, Nothing, PipelineExecutionArn] =
      ZIO.succeed(pipelineExecutionArn)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ListPipelineParametersForExecutionRequest
  ) extends zio.aws.sagemaker.model.ListPipelineParametersForExecutionRequest.ReadOnly {
    override val pipelineExecutionArn: PipelineExecutionArn =
      zio.aws.sagemaker.model.primitives
        .PipelineExecutionArn(impl.pipelineExecutionArn())
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.sagemaker.model.primitives.NextToken(value))
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.sagemaker.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ListPipelineParametersForExecutionRequest
  ): zio.aws.sagemaker.model.ListPipelineParametersForExecutionRequest.ReadOnly =
    new Wrapper(impl)
}
