package zio.aws.sagemaker.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sagemaker.model.primitives.{MaxResults, NextToken}
import scala.jdk.CollectionConverters._
final case class ListModelMetadataRequest(
    searchExpression: Option[
      zio.aws.sagemaker.model.ModelMetadataSearchExpression
    ] = None,
    nextToken: Option[NextToken] = None,
    maxResults: Option[MaxResults] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ListModelMetadataRequest = {
    import ListModelMetadataRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ListModelMetadataRequest
      .builder()
      .optionallyWith(searchExpression.map(value => value.buildAwsValue()))(
        _.searchExpression
      )
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.ListModelMetadataRequest.ReadOnly =
    zio.aws.sagemaker.model.ListModelMetadataRequest.wrap(buildAwsValue())
}
object ListModelMetadataRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ListModelMetadataRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ListModelMetadataRequest =
      zio.aws.sagemaker.model.ListModelMetadataRequest(
        searchExpression.map(value => value.asEditable),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def searchExpression
        : Option[zio.aws.sagemaker.model.ModelMetadataSearchExpression.ReadOnly]
    def nextToken: Option[NextToken]
    def maxResults: Option[MaxResults]
    def getSearchExpression: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.ModelMetadataSearchExpression.ReadOnly
    ] = AwsError.unwrapOptionField("searchExpression", searchExpression)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ListModelMetadataRequest
  ) extends zio.aws.sagemaker.model.ListModelMetadataRequest.ReadOnly {
    override val searchExpression: Option[
      zio.aws.sagemaker.model.ModelMetadataSearchExpression.ReadOnly
    ] = scala
      .Option(impl.searchExpression())
      .map(value =>
        zio.aws.sagemaker.model.ModelMetadataSearchExpression.wrap(value)
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.sagemaker.model.primitives.NextToken(value))
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.sagemaker.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ListModelMetadataRequest
  ): zio.aws.sagemaker.model.ListModelMetadataRequest.ReadOnly = new Wrapper(
    impl
  )
}
