package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sagemaker.model.primitives.NextToken
import scala.jdk.CollectionConverters._
final case class ListLabelingJobsResponse(
    labelingJobSummaryList: Option[
      Iterable[zio.aws.sagemaker.model.LabelingJobSummary]
    ] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ListLabelingJobsResponse = {
    import ListLabelingJobsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ListLabelingJobsResponse
      .builder()
      .optionallyWith(
        labelingJobSummaryList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.labelingJobSummaryList)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.ListLabelingJobsResponse.ReadOnly =
    zio.aws.sagemaker.model.ListLabelingJobsResponse.wrap(buildAwsValue())
}
object ListLabelingJobsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ListLabelingJobsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ListLabelingJobsResponse =
      zio.aws.sagemaker.model.ListLabelingJobsResponse(
        labelingJobSummaryList.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def labelingJobSummaryList
        : Option[List[zio.aws.sagemaker.model.LabelingJobSummary.ReadOnly]]
    def nextToken: Option[NextToken]
    def getLabelingJobSummaryList: ZIO[Any, AwsError, List[
      zio.aws.sagemaker.model.LabelingJobSummary.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "labelingJobSummaryList",
      labelingJobSummaryList
    )
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ListLabelingJobsResponse
  ) extends zio.aws.sagemaker.model.ListLabelingJobsResponse.ReadOnly {
    override val labelingJobSummaryList
        : Option[List[zio.aws.sagemaker.model.LabelingJobSummary.ReadOnly]] =
      scala
        .Option(impl.labelingJobSummaryList())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sagemaker.model.LabelingJobSummary.wrap(item)
          }.toList
        )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.sagemaker.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ListLabelingJobsResponse
  ): zio.aws.sagemaker.model.ListLabelingJobsResponse.ReadOnly = new Wrapper(
    impl
  )
}
