package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sagemaker.model.primitives.NextToken
import scala.jdk.CollectionConverters._
final case class ListAssociationsResponse(
    associationSummaries: Option[
      Iterable[zio.aws.sagemaker.model.AssociationSummary]
    ] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ListAssociationsResponse = {
    import ListAssociationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ListAssociationsResponse
      .builder()
      .optionallyWith(
        associationSummaries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.associationSummaries)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.ListAssociationsResponse.ReadOnly =
    zio.aws.sagemaker.model.ListAssociationsResponse.wrap(buildAwsValue())
}
object ListAssociationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ListAssociationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ListAssociationsResponse =
      zio.aws.sagemaker.model.ListAssociationsResponse(
        associationSummaries.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def associationSummaries
        : Option[List[zio.aws.sagemaker.model.AssociationSummary.ReadOnly]]
    def nextToken: Option[NextToken]
    def getAssociationSummaries: ZIO[Any, AwsError, List[
      zio.aws.sagemaker.model.AssociationSummary.ReadOnly
    ]] =
      AwsError.unwrapOptionField("associationSummaries", associationSummaries)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ListAssociationsResponse
  ) extends zio.aws.sagemaker.model.ListAssociationsResponse.ReadOnly {
    override val associationSummaries
        : Option[List[zio.aws.sagemaker.model.AssociationSummary.ReadOnly]] =
      scala
        .Option(impl.associationSummaries())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sagemaker.model.AssociationSummary.wrap(item)
          }.toList
        )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.sagemaker.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ListAssociationsResponse
  ): zio.aws.sagemaker.model.ListAssociationsResponse.ReadOnly = new Wrapper(
    impl
  )
}
