package zio.aws.sagemaker.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sagemaker.model.primitives.{
  UserProfileName,
  DomainId,
  MaxResults,
  NextToken
}
import scala.jdk.CollectionConverters._
final case class ListAppsRequest(
    nextToken: Option[NextToken] = None,
    maxResults: Option[MaxResults] = None,
    sortOrder: Option[zio.aws.sagemaker.model.SortOrder] = None,
    sortBy: Option[zio.aws.sagemaker.model.AppSortKey] = None,
    domainIdEquals: Option[DomainId] = None,
    userProfileNameEquals: Option[UserProfileName] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ListAppsRequest = {
    import ListAppsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ListAppsRequest
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(sortOrder.map(value => value.unwrap))(_.sortOrder)
      .optionallyWith(sortBy.map(value => value.unwrap))(_.sortBy)
      .optionallyWith(
        domainIdEquals.map(value => DomainId.unwrap(value): java.lang.String)
      )(_.domainIdEquals)
      .optionallyWith(
        userProfileNameEquals.map(value =>
          UserProfileName.unwrap(value): java.lang.String
        )
      )(_.userProfileNameEquals)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.ListAppsRequest.ReadOnly =
    zio.aws.sagemaker.model.ListAppsRequest.wrap(buildAwsValue())
}
object ListAppsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ListAppsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ListAppsRequest =
      zio.aws.sagemaker.model.ListAppsRequest(
        nextToken.map(value => value),
        maxResults.map(value => value),
        sortOrder.map(value => value),
        sortBy.map(value => value),
        domainIdEquals.map(value => value),
        userProfileNameEquals.map(value => value)
      )
    def nextToken: Option[NextToken]
    def maxResults: Option[MaxResults]
    def sortOrder: Option[zio.aws.sagemaker.model.SortOrder]
    def sortBy: Option[zio.aws.sagemaker.model.AppSortKey]
    def domainIdEquals: Option[DomainId]
    def userProfileNameEquals: Option[UserProfileName]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getSortOrder: ZIO[Any, AwsError, zio.aws.sagemaker.model.SortOrder] =
      AwsError.unwrapOptionField("sortOrder", sortOrder)
    def getSortBy: ZIO[Any, AwsError, zio.aws.sagemaker.model.AppSortKey] =
      AwsError.unwrapOptionField("sortBy", sortBy)
    def getDomainIdEquals: ZIO[Any, AwsError, DomainId] =
      AwsError.unwrapOptionField("domainIdEquals", domainIdEquals)
    def getUserProfileNameEquals: ZIO[Any, AwsError, UserProfileName] =
      AwsError.unwrapOptionField("userProfileNameEquals", userProfileNameEquals)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ListAppsRequest
  ) extends zio.aws.sagemaker.model.ListAppsRequest.ReadOnly {
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.sagemaker.model.primitives.NextToken(value))
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.sagemaker.model.primitives.MaxResults(value))
    override val sortOrder: Option[zio.aws.sagemaker.model.SortOrder] = scala
      .Option(impl.sortOrder())
      .map(value => zio.aws.sagemaker.model.SortOrder.wrap(value))
    override val sortBy: Option[zio.aws.sagemaker.model.AppSortKey] = scala
      .Option(impl.sortBy())
      .map(value => zio.aws.sagemaker.model.AppSortKey.wrap(value))
    override val domainIdEquals: Option[DomainId] = scala
      .Option(impl.domainIdEquals())
      .map(value => zio.aws.sagemaker.model.primitives.DomainId(value))
    override val userProfileNameEquals: Option[UserProfileName] = scala
      .Option(impl.userProfileNameEquals())
      .map(value => zio.aws.sagemaker.model.primitives.UserProfileName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ListAppsRequest
  ): zio.aws.sagemaker.model.ListAppsRequest.ReadOnly = new Wrapper(impl)
}
