package zio.aws.sagemaker.model
import zio.aws.sagemaker.model.primitives.{
  Timestamp,
  FailureReason,
  ImageArn,
  ImageVersionNumber,
  ImageVersionArn
}
import java.time.Instant
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ImageVersion(
    creationTime: Timestamp,
    failureReason: Option[FailureReason] = None,
    imageArn: ImageArn,
    imageVersionArn: ImageVersionArn,
    imageVersionStatus: zio.aws.sagemaker.model.ImageVersionStatus,
    lastModifiedTime: Timestamp,
    version: ImageVersionNumber
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ImageVersion = {
    import ImageVersion.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ImageVersion
      .builder()
      .creationTime(Timestamp.unwrap(creationTime): Instant)
      .optionallyWith(
        failureReason.map(value =>
          FailureReason.unwrap(value): java.lang.String
        )
      )(_.failureReason)
      .imageArn(ImageArn.unwrap(imageArn): java.lang.String)
      .imageVersionArn(
        ImageVersionArn.unwrap(imageVersionArn): java.lang.String
      )
      .imageVersionStatus(imageVersionStatus.unwrap)
      .lastModifiedTime(Timestamp.unwrap(lastModifiedTime): Instant)
      .version(ImageVersionNumber.unwrap(version): Integer)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.ImageVersion.ReadOnly =
    zio.aws.sagemaker.model.ImageVersion.wrap(buildAwsValue())
}
object ImageVersion {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ImageVersion
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ImageVersion =
      zio.aws.sagemaker.model.ImageVersion(
        creationTime,
        failureReason.map(value => value),
        imageArn,
        imageVersionArn,
        imageVersionStatus,
        lastModifiedTime,
        version
      )
    def creationTime: Timestamp
    def failureReason: Option[FailureReason]
    def imageArn: ImageArn
    def imageVersionArn: ImageVersionArn
    def imageVersionStatus: zio.aws.sagemaker.model.ImageVersionStatus
    def lastModifiedTime: Timestamp
    def version: ImageVersionNumber
    def getCreationTime: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(creationTime)
    def getFailureReason: ZIO[Any, AwsError, FailureReason] =
      AwsError.unwrapOptionField("failureReason", failureReason)
    def getImageArn: ZIO[Any, Nothing, ImageArn] = ZIO.succeed(imageArn)
    def getImageVersionArn: ZIO[Any, Nothing, ImageVersionArn] =
      ZIO.succeed(imageVersionArn)
    def getImageVersionStatus
        : ZIO[Any, Nothing, zio.aws.sagemaker.model.ImageVersionStatus] =
      ZIO.succeed(imageVersionStatus)
    def getLastModifiedTime: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(lastModifiedTime)
    def getVersion: ZIO[Any, Nothing, ImageVersionNumber] = ZIO.succeed(version)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ImageVersion
  ) extends zio.aws.sagemaker.model.ImageVersion.ReadOnly {
    override val creationTime: Timestamp =
      zio.aws.sagemaker.model.primitives.Timestamp(impl.creationTime())
    override val failureReason: Option[FailureReason] = scala
      .Option(impl.failureReason())
      .map(value => zio.aws.sagemaker.model.primitives.FailureReason(value))
    override val imageArn: ImageArn =
      zio.aws.sagemaker.model.primitives.ImageArn(impl.imageArn())
    override val imageVersionArn: ImageVersionArn =
      zio.aws.sagemaker.model.primitives.ImageVersionArn(impl.imageVersionArn())
    override val imageVersionStatus
        : zio.aws.sagemaker.model.ImageVersionStatus =
      zio.aws.sagemaker.model.ImageVersionStatus.wrap(impl.imageVersionStatus())
    override val lastModifiedTime: Timestamp =
      zio.aws.sagemaker.model.primitives.Timestamp(impl.lastModifiedTime())
    override val version: ImageVersionNumber =
      zio.aws.sagemaker.model.primitives.ImageVersionNumber(impl.version())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ImageVersion
  ): zio.aws.sagemaker.model.ImageVersion.ReadOnly = new Wrapper(impl)
}
