package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sagemaker.model.primitives.{
  ResourcePolicyString,
  LineageGroupArn
}
import scala.jdk.CollectionConverters._
final case class GetLineageGroupPolicyResponse(
    lineageGroupArn: Option[LineageGroupArn] = None,
    resourcePolicy: Option[ResourcePolicyString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.GetLineageGroupPolicyResponse = {
    import GetLineageGroupPolicyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.GetLineageGroupPolicyResponse
      .builder()
      .optionallyWith(
        lineageGroupArn.map(value =>
          LineageGroupArn.unwrap(value): java.lang.String
        )
      )(_.lineageGroupArn)
      .optionallyWith(
        resourcePolicy.map(value =>
          ResourcePolicyString.unwrap(value): java.lang.String
        )
      )(_.resourcePolicy)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.GetLineageGroupPolicyResponse.ReadOnly =
    zio.aws.sagemaker.model.GetLineageGroupPolicyResponse.wrap(buildAwsValue())
}
object GetLineageGroupPolicyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.GetLineageGroupPolicyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.GetLineageGroupPolicyResponse =
      zio.aws.sagemaker.model.GetLineageGroupPolicyResponse(
        lineageGroupArn.map(value => value),
        resourcePolicy.map(value => value)
      )
    def lineageGroupArn: Option[LineageGroupArn]
    def resourcePolicy: Option[ResourcePolicyString]
    def getLineageGroupArn: ZIO[Any, AwsError, LineageGroupArn] =
      AwsError.unwrapOptionField("lineageGroupArn", lineageGroupArn)
    def getResourcePolicy: ZIO[Any, AwsError, ResourcePolicyString] =
      AwsError.unwrapOptionField("resourcePolicy", resourcePolicy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.GetLineageGroupPolicyResponse
  ) extends zio.aws.sagemaker.model.GetLineageGroupPolicyResponse.ReadOnly {
    override val lineageGroupArn: Option[LineageGroupArn] = scala
      .Option(impl.lineageGroupArn())
      .map(value => zio.aws.sagemaker.model.primitives.LineageGroupArn(value))
    override val resourcePolicy: Option[ResourcePolicyString] = scala
      .Option(impl.resourcePolicy())
      .map(value =>
        zio.aws.sagemaker.model.primitives.ResourcePolicyString(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.GetLineageGroupPolicyResponse
  ): zio.aws.sagemaker.model.GetLineageGroupPolicyResponse.ReadOnly =
    new Wrapper(impl)
}
