package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sagemaker.model.primitives.MetricValue
import scala.jdk.CollectionConverters._
final case class FinalAutoMLJobObjectiveMetric(
    `type`: Option[zio.aws.sagemaker.model.AutoMLJobObjectiveType] = None,
    metricName: zio.aws.sagemaker.model.AutoMLMetricEnum,
    value: MetricValue
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.FinalAutoMLJobObjectiveMetric = {
    import FinalAutoMLJobObjectiveMetric.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.FinalAutoMLJobObjectiveMetric
      .builder()
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .metricName(metricName.unwrap)
      .value(MetricValue.unwrap(value): java.lang.Float)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.FinalAutoMLJobObjectiveMetric.ReadOnly =
    zio.aws.sagemaker.model.FinalAutoMLJobObjectiveMetric.wrap(buildAwsValue())
}
object FinalAutoMLJobObjectiveMetric {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.FinalAutoMLJobObjectiveMetric
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.FinalAutoMLJobObjectiveMetric =
      zio.aws.sagemaker.model.FinalAutoMLJobObjectiveMetric(
        `type`.map(value => value),
        metricName,
        value
      )
    def `type`: Option[zio.aws.sagemaker.model.AutoMLJobObjectiveType]
    def metricName: zio.aws.sagemaker.model.AutoMLMetricEnum
    def value: MetricValue
    def getType
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.AutoMLJobObjectiveType] =
      AwsError.unwrapOptionField("type", `type`)
    def getMetricName
        : ZIO[Any, Nothing, zio.aws.sagemaker.model.AutoMLMetricEnum] =
      ZIO.succeed(metricName)
    def getValue: ZIO[Any, Nothing, MetricValue] = ZIO.succeed(value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.FinalAutoMLJobObjectiveMetric
  ) extends zio.aws.sagemaker.model.FinalAutoMLJobObjectiveMetric.ReadOnly {
    override val `type`
        : Option[zio.aws.sagemaker.model.AutoMLJobObjectiveType] = scala
      .Option(impl.`type`())
      .map(value => zio.aws.sagemaker.model.AutoMLJobObjectiveType.wrap(value))
    override val metricName: zio.aws.sagemaker.model.AutoMLMetricEnum =
      zio.aws.sagemaker.model.AutoMLMetricEnum.wrap(impl.metricName())
    override val value: MetricValue =
      zio.aws.sagemaker.model.primitives.MetricValue(impl.value())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.FinalAutoMLJobObjectiveMetric
  ): zio.aws.sagemaker.model.FinalAutoMLJobObjectiveMetric.ReadOnly =
    new Wrapper(impl)
}
