package zio.aws.sagemaker.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sagemaker.model.primitives.{DefaultGid, DefaultUid, MountPath}
import scala.jdk.CollectionConverters._
final case class FileSystemConfig(
    mountPath: Option[MountPath] = None,
    defaultUid: Option[DefaultUid] = None,
    defaultGid: Option[DefaultGid] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.FileSystemConfig = {
    import FileSystemConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.FileSystemConfig
      .builder()
      .optionallyWith(
        mountPath.map(value => MountPath.unwrap(value): java.lang.String)
      )(_.mountPath)
      .optionallyWith(
        defaultUid.map(value => DefaultUid.unwrap(value): Integer)
      )(_.defaultUid)
      .optionallyWith(
        defaultGid.map(value => DefaultGid.unwrap(value): Integer)
      )(_.defaultGid)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.FileSystemConfig.ReadOnly =
    zio.aws.sagemaker.model.FileSystemConfig.wrap(buildAwsValue())
}
object FileSystemConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.FileSystemConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.FileSystemConfig =
      zio.aws.sagemaker.model.FileSystemConfig(
        mountPath.map(value => value),
        defaultUid.map(value => value),
        defaultGid.map(value => value)
      )
    def mountPath: Option[MountPath]
    def defaultUid: Option[DefaultUid]
    def defaultGid: Option[DefaultGid]
    def getMountPath: ZIO[Any, AwsError, MountPath] =
      AwsError.unwrapOptionField("mountPath", mountPath)
    def getDefaultUid: ZIO[Any, AwsError, DefaultUid] =
      AwsError.unwrapOptionField("defaultUid", defaultUid)
    def getDefaultGid: ZIO[Any, AwsError, DefaultGid] =
      AwsError.unwrapOptionField("defaultGid", defaultGid)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.FileSystemConfig
  ) extends zio.aws.sagemaker.model.FileSystemConfig.ReadOnly {
    override val mountPath: Option[MountPath] = scala
      .Option(impl.mountPath())
      .map(value => zio.aws.sagemaker.model.primitives.MountPath(value))
    override val defaultUid: Option[DefaultUid] = scala
      .Option(impl.defaultUid())
      .map(value => zio.aws.sagemaker.model.primitives.DefaultUid(value))
    override val defaultGid: Option[DefaultGid] = scala
      .Option(impl.defaultGid())
      .map(value => zio.aws.sagemaker.model.primitives.DefaultGid(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.FileSystemConfig
  ): zio.aws.sagemaker.model.FileSystemConfig.ReadOnly = new Wrapper(impl)
}
