package zio.aws.sagemaker.model
import zio.aws.sagemaker.model.primitives.{
  SubnetId,
  CreationTime,
  RoleArn,
  SecurityGroupId,
  NetworkInterfaceId,
  FailureReason,
  NotebookInstanceVolumeSizeInGB,
  LastModifiedTime,
  NotebookInstanceArn,
  NotebookInstanceUrl,
  NotebookInstanceName,
  KmsKeyId,
  CodeRepositoryNameOrUrl,
  NotebookInstanceLifecycleConfigName,
  PlatformIdentifier
}
import java.time.Instant
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class DescribeNotebookInstanceResponse(
    notebookInstanceArn: Option[NotebookInstanceArn] = None,
    notebookInstanceName: Option[NotebookInstanceName] = None,
    notebookInstanceStatus: Option[
      zio.aws.sagemaker.model.NotebookInstanceStatus
    ] = None,
    failureReason: Option[FailureReason] = None,
    url: Option[NotebookInstanceUrl] = None,
    instanceType: Option[zio.aws.sagemaker.model.InstanceType] = None,
    subnetId: Option[SubnetId] = None,
    securityGroups: Option[Iterable[SecurityGroupId]] = None,
    roleArn: Option[RoleArn] = None,
    kmsKeyId: Option[KmsKeyId] = None,
    networkInterfaceId: Option[NetworkInterfaceId] = None,
    lastModifiedTime: Option[LastModifiedTime] = None,
    creationTime: Option[CreationTime] = None,
    notebookInstanceLifecycleConfigName: Option[
      NotebookInstanceLifecycleConfigName
    ] = None,
    directInternetAccess: Option[zio.aws.sagemaker.model.DirectInternetAccess] =
      None,
    volumeSizeInGB: Option[NotebookInstanceVolumeSizeInGB] = None,
    acceleratorTypes: Option[
      Iterable[zio.aws.sagemaker.model.NotebookInstanceAcceleratorType]
    ] = None,
    defaultCodeRepository: Option[CodeRepositoryNameOrUrl] = None,
    additionalCodeRepositories: Option[Iterable[CodeRepositoryNameOrUrl]] =
      None,
    rootAccess: Option[zio.aws.sagemaker.model.RootAccess] = None,
    platformIdentifier: Option[PlatformIdentifier] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.DescribeNotebookInstanceResponse = {
    import DescribeNotebookInstanceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.DescribeNotebookInstanceResponse
      .builder()
      .optionallyWith(
        notebookInstanceArn.map(value =>
          NotebookInstanceArn.unwrap(value): java.lang.String
        )
      )(_.notebookInstanceArn)
      .optionallyWith(
        notebookInstanceName.map(value =>
          NotebookInstanceName.unwrap(value): java.lang.String
        )
      )(_.notebookInstanceName)
      .optionallyWith(notebookInstanceStatus.map(value => value.unwrap))(
        _.notebookInstanceStatus
      )
      .optionallyWith(
        failureReason.map(value =>
          FailureReason.unwrap(value): java.lang.String
        )
      )(_.failureReason)
      .optionallyWith(
        url.map(value => NotebookInstanceUrl.unwrap(value): java.lang.String)
      )(_.url)
      .optionallyWith(instanceType.map(value => value.unwrap))(_.instanceType)
      .optionallyWith(
        subnetId.map(value => SubnetId.unwrap(value): java.lang.String)
      )(_.subnetId)
      .optionallyWith(
        securityGroups.map(value =>
          value.map { item =>
            SecurityGroupId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.securityGroups)
      .optionallyWith(
        roleArn.map(value => RoleArn.unwrap(value): java.lang.String)
      )(_.roleArn)
      .optionallyWith(
        kmsKeyId.map(value => KmsKeyId.unwrap(value): java.lang.String)
      )(_.kmsKeyId)
      .optionallyWith(
        networkInterfaceId.map(value =>
          NetworkInterfaceId.unwrap(value): java.lang.String
        )
      )(_.networkInterfaceId)
      .optionallyWith(
        lastModifiedTime.map(value => LastModifiedTime.unwrap(value): Instant)
      )(_.lastModifiedTime)
      .optionallyWith(
        creationTime.map(value => CreationTime.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(
        notebookInstanceLifecycleConfigName.map(value =>
          NotebookInstanceLifecycleConfigName.unwrap(value): java.lang.String
        )
      )(_.notebookInstanceLifecycleConfigName)
      .optionallyWith(directInternetAccess.map(value => value.unwrap))(
        _.directInternetAccess
      )
      .optionallyWith(
        volumeSizeInGB.map(value =>
          NotebookInstanceVolumeSizeInGB.unwrap(value): Integer
        )
      )(_.volumeSizeInGB)
      .optionallyWith(
        acceleratorTypes.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.acceleratorTypesWithStrings)
      .optionallyWith(
        defaultCodeRepository.map(value =>
          CodeRepositoryNameOrUrl.unwrap(value): java.lang.String
        )
      )(_.defaultCodeRepository)
      .optionallyWith(
        additionalCodeRepositories.map(value =>
          value.map { item =>
            CodeRepositoryNameOrUrl.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.additionalCodeRepositories)
      .optionallyWith(rootAccess.map(value => value.unwrap))(_.rootAccess)
      .optionallyWith(
        platformIdentifier.map(value =>
          PlatformIdentifier.unwrap(value): java.lang.String
        )
      )(_.platformIdentifier)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.DescribeNotebookInstanceResponse.ReadOnly =
    zio.aws.sagemaker.model.DescribeNotebookInstanceResponse
      .wrap(buildAwsValue())
}
object DescribeNotebookInstanceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.DescribeNotebookInstanceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.DescribeNotebookInstanceResponse =
      zio.aws.sagemaker.model.DescribeNotebookInstanceResponse(
        notebookInstanceArn.map(value => value),
        notebookInstanceName.map(value => value),
        notebookInstanceStatus.map(value => value),
        failureReason.map(value => value),
        url.map(value => value),
        instanceType.map(value => value),
        subnetId.map(value => value),
        securityGroups.map(value => value),
        roleArn.map(value => value),
        kmsKeyId.map(value => value),
        networkInterfaceId.map(value => value),
        lastModifiedTime.map(value => value),
        creationTime.map(value => value),
        notebookInstanceLifecycleConfigName.map(value => value),
        directInternetAccess.map(value => value),
        volumeSizeInGB.map(value => value),
        acceleratorTypes.map(value => value),
        defaultCodeRepository.map(value => value),
        additionalCodeRepositories.map(value => value),
        rootAccess.map(value => value),
        platformIdentifier.map(value => value)
      )
    def notebookInstanceArn: Option[NotebookInstanceArn]
    def notebookInstanceName: Option[NotebookInstanceName]
    def notebookInstanceStatus
        : Option[zio.aws.sagemaker.model.NotebookInstanceStatus]
    def failureReason: Option[FailureReason]
    def url: Option[NotebookInstanceUrl]
    def instanceType: Option[zio.aws.sagemaker.model.InstanceType]
    def subnetId: Option[SubnetId]
    def securityGroups: Option[List[SecurityGroupId]]
    def roleArn: Option[RoleArn]
    def kmsKeyId: Option[KmsKeyId]
    def networkInterfaceId: Option[NetworkInterfaceId]
    def lastModifiedTime: Option[LastModifiedTime]
    def creationTime: Option[CreationTime]
    def notebookInstanceLifecycleConfigName
        : Option[NotebookInstanceLifecycleConfigName]
    def directInternetAccess
        : Option[zio.aws.sagemaker.model.DirectInternetAccess]
    def volumeSizeInGB: Option[NotebookInstanceVolumeSizeInGB]
    def acceleratorTypes
        : Option[List[zio.aws.sagemaker.model.NotebookInstanceAcceleratorType]]
    def defaultCodeRepository: Option[CodeRepositoryNameOrUrl]
    def additionalCodeRepositories: Option[List[CodeRepositoryNameOrUrl]]
    def rootAccess: Option[zio.aws.sagemaker.model.RootAccess]
    def platformIdentifier: Option[PlatformIdentifier]
    def getNotebookInstanceArn: ZIO[Any, AwsError, NotebookInstanceArn] =
      AwsError.unwrapOptionField("notebookInstanceArn", notebookInstanceArn)
    def getNotebookInstanceName: ZIO[Any, AwsError, NotebookInstanceName] =
      AwsError.unwrapOptionField("notebookInstanceName", notebookInstanceName)
    def getNotebookInstanceStatus
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.NotebookInstanceStatus] =
      AwsError.unwrapOptionField(
        "notebookInstanceStatus",
        notebookInstanceStatus
      )
    def getFailureReason: ZIO[Any, AwsError, FailureReason] =
      AwsError.unwrapOptionField("failureReason", failureReason)
    def getUrl: ZIO[Any, AwsError, NotebookInstanceUrl] =
      AwsError.unwrapOptionField("url", url)
    def getInstanceType
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.InstanceType] =
      AwsError.unwrapOptionField("instanceType", instanceType)
    def getSubnetId: ZIO[Any, AwsError, SubnetId] =
      AwsError.unwrapOptionField("subnetId", subnetId)
    def getSecurityGroups: ZIO[Any, AwsError, List[SecurityGroupId]] =
      AwsError.unwrapOptionField("securityGroups", securityGroups)
    def getRoleArn: ZIO[Any, AwsError, RoleArn] =
      AwsError.unwrapOptionField("roleArn", roleArn)
    def getKmsKeyId: ZIO[Any, AwsError, KmsKeyId] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getNetworkInterfaceId: ZIO[Any, AwsError, NetworkInterfaceId] =
      AwsError.unwrapOptionField("networkInterfaceId", networkInterfaceId)
    def getLastModifiedTime: ZIO[Any, AwsError, LastModifiedTime] =
      AwsError.unwrapOptionField("lastModifiedTime", lastModifiedTime)
    def getCreationTime: ZIO[Any, AwsError, CreationTime] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getNotebookInstanceLifecycleConfigName
        : ZIO[Any, AwsError, NotebookInstanceLifecycleConfigName] =
      AwsError.unwrapOptionField(
        "notebookInstanceLifecycleConfigName",
        notebookInstanceLifecycleConfigName
      )
    def getDirectInternetAccess
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.DirectInternetAccess] =
      AwsError.unwrapOptionField("directInternetAccess", directInternetAccess)
    def getVolumeSizeInGB: ZIO[Any, AwsError, NotebookInstanceVolumeSizeInGB] =
      AwsError.unwrapOptionField("volumeSizeInGB", volumeSizeInGB)
    def getAcceleratorTypes: ZIO[Any, AwsError, List[
      zio.aws.sagemaker.model.NotebookInstanceAcceleratorType
    ]] = AwsError.unwrapOptionField("acceleratorTypes", acceleratorTypes)
    def getDefaultCodeRepository: ZIO[Any, AwsError, CodeRepositoryNameOrUrl] =
      AwsError.unwrapOptionField("defaultCodeRepository", defaultCodeRepository)
    def getAdditionalCodeRepositories
        : ZIO[Any, AwsError, List[CodeRepositoryNameOrUrl]] =
      AwsError.unwrapOptionField(
        "additionalCodeRepositories",
        additionalCodeRepositories
      )
    def getRootAccess: ZIO[Any, AwsError, zio.aws.sagemaker.model.RootAccess] =
      AwsError.unwrapOptionField("rootAccess", rootAccess)
    def getPlatformIdentifier: ZIO[Any, AwsError, PlatformIdentifier] =
      AwsError.unwrapOptionField("platformIdentifier", platformIdentifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeNotebookInstanceResponse
  ) extends zio.aws.sagemaker.model.DescribeNotebookInstanceResponse.ReadOnly {
    override val notebookInstanceArn: Option[NotebookInstanceArn] = scala
      .Option(impl.notebookInstanceArn())
      .map(value =>
        zio.aws.sagemaker.model.primitives.NotebookInstanceArn(value)
      )
    override val notebookInstanceName: Option[NotebookInstanceName] = scala
      .Option(impl.notebookInstanceName())
      .map(value =>
        zio.aws.sagemaker.model.primitives.NotebookInstanceName(value)
      )
    override val notebookInstanceStatus
        : Option[zio.aws.sagemaker.model.NotebookInstanceStatus] = scala
      .Option(impl.notebookInstanceStatus())
      .map(value => zio.aws.sagemaker.model.NotebookInstanceStatus.wrap(value))
    override val failureReason: Option[FailureReason] = scala
      .Option(impl.failureReason())
      .map(value => zio.aws.sagemaker.model.primitives.FailureReason(value))
    override val url: Option[NotebookInstanceUrl] = scala
      .Option(impl.url())
      .map(value =>
        zio.aws.sagemaker.model.primitives.NotebookInstanceUrl(value)
      )
    override val instanceType: Option[zio.aws.sagemaker.model.InstanceType] =
      scala
        .Option(impl.instanceType())
        .map(value => zio.aws.sagemaker.model.InstanceType.wrap(value))
    override val subnetId: Option[SubnetId] = scala
      .Option(impl.subnetId())
      .map(value => zio.aws.sagemaker.model.primitives.SubnetId(value))
    override val securityGroups: Option[List[SecurityGroupId]] = scala
      .Option(impl.securityGroups())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.sagemaker.model.primitives.SecurityGroupId(item)
        }.toList
      )
    override val roleArn: Option[RoleArn] = scala
      .Option(impl.roleArn())
      .map(value => zio.aws.sagemaker.model.primitives.RoleArn(value))
    override val kmsKeyId: Option[KmsKeyId] = scala
      .Option(impl.kmsKeyId())
      .map(value => zio.aws.sagemaker.model.primitives.KmsKeyId(value))
    override val networkInterfaceId: Option[NetworkInterfaceId] = scala
      .Option(impl.networkInterfaceId())
      .map(value =>
        zio.aws.sagemaker.model.primitives.NetworkInterfaceId(value)
      )
    override val lastModifiedTime: Option[LastModifiedTime] = scala
      .Option(impl.lastModifiedTime())
      .map(value => zio.aws.sagemaker.model.primitives.LastModifiedTime(value))
    override val creationTime: Option[CreationTime] = scala
      .Option(impl.creationTime())
      .map(value => zio.aws.sagemaker.model.primitives.CreationTime(value))
    override val notebookInstanceLifecycleConfigName
        : Option[NotebookInstanceLifecycleConfigName] = scala
      .Option(impl.notebookInstanceLifecycleConfigName())
      .map(value =>
        zio.aws.sagemaker.model.primitives
          .NotebookInstanceLifecycleConfigName(value)
      )
    override val directInternetAccess
        : Option[zio.aws.sagemaker.model.DirectInternetAccess] = scala
      .Option(impl.directInternetAccess())
      .map(value => zio.aws.sagemaker.model.DirectInternetAccess.wrap(value))
    override val volumeSizeInGB: Option[NotebookInstanceVolumeSizeInGB] = scala
      .Option(impl.volumeSizeInGB())
      .map(value =>
        zio.aws.sagemaker.model.primitives.NotebookInstanceVolumeSizeInGB(value)
      )
    override val acceleratorTypes: Option[
      List[zio.aws.sagemaker.model.NotebookInstanceAcceleratorType]
    ] = scala
      .Option(impl.acceleratorTypes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.sagemaker.model.NotebookInstanceAcceleratorType.wrap(item)
        }.toList
      )
    override val defaultCodeRepository: Option[CodeRepositoryNameOrUrl] = scala
      .Option(impl.defaultCodeRepository())
      .map(value =>
        zio.aws.sagemaker.model.primitives.CodeRepositoryNameOrUrl(value)
      )
    override val additionalCodeRepositories
        : Option[List[CodeRepositoryNameOrUrl]] = scala
      .Option(impl.additionalCodeRepositories())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.sagemaker.model.primitives.CodeRepositoryNameOrUrl(item)
        }.toList
      )
    override val rootAccess: Option[zio.aws.sagemaker.model.RootAccess] = scala
      .Option(impl.rootAccess())
      .map(value => zio.aws.sagemaker.model.RootAccess.wrap(value))
    override val platformIdentifier: Option[PlatformIdentifier] = scala
      .Option(impl.platformIdentifier())
      .map(value =>
        zio.aws.sagemaker.model.primitives.PlatformIdentifier(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeNotebookInstanceResponse
  ): zio.aws.sagemaker.model.DescribeNotebookInstanceResponse.ReadOnly =
    new Wrapper(impl)
}
