package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.sagemaker.model.primitives.{
  CreationTime,
  EntityDescription,
  ModelPackageGroupArn,
  EntityName
}
import scala.jdk.CollectionConverters._
final case class DescribeModelPackageGroupResponse(
    modelPackageGroupName: EntityName,
    modelPackageGroupArn: ModelPackageGroupArn,
    modelPackageGroupDescription: Option[EntityDescription] = None,
    creationTime: CreationTime,
    createdBy: zio.aws.sagemaker.model.UserContext,
    modelPackageGroupStatus: zio.aws.sagemaker.model.ModelPackageGroupStatus
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.DescribeModelPackageGroupResponse = {
    import DescribeModelPackageGroupResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.DescribeModelPackageGroupResponse
      .builder()
      .modelPackageGroupName(
        EntityName.unwrap(modelPackageGroupName): java.lang.String
      )
      .modelPackageGroupArn(
        ModelPackageGroupArn.unwrap(modelPackageGroupArn): java.lang.String
      )
      .optionallyWith(
        modelPackageGroupDescription.map(value =>
          EntityDescription.unwrap(value): java.lang.String
        )
      )(_.modelPackageGroupDescription)
      .creationTime(CreationTime.unwrap(creationTime): Instant)
      .createdBy(createdBy.buildAwsValue())
      .modelPackageGroupStatus(modelPackageGroupStatus.unwrap)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.DescribeModelPackageGroupResponse.ReadOnly =
    zio.aws.sagemaker.model.DescribeModelPackageGroupResponse
      .wrap(buildAwsValue())
}
object DescribeModelPackageGroupResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.DescribeModelPackageGroupResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.DescribeModelPackageGroupResponse =
      zio.aws.sagemaker.model.DescribeModelPackageGroupResponse(
        modelPackageGroupName,
        modelPackageGroupArn,
        modelPackageGroupDescription.map(value => value),
        creationTime,
        createdBy.asEditable,
        modelPackageGroupStatus
      )
    def modelPackageGroupName: EntityName
    def modelPackageGroupArn: ModelPackageGroupArn
    def modelPackageGroupDescription: Option[EntityDescription]
    def creationTime: CreationTime
    def createdBy: zio.aws.sagemaker.model.UserContext.ReadOnly
    def modelPackageGroupStatus: zio.aws.sagemaker.model.ModelPackageGroupStatus
    def getModelPackageGroupName: ZIO[Any, Nothing, EntityName] =
      ZIO.succeed(modelPackageGroupName)
    def getModelPackageGroupArn: ZIO[Any, Nothing, ModelPackageGroupArn] =
      ZIO.succeed(modelPackageGroupArn)
    def getModelPackageGroupDescription: ZIO[Any, AwsError, EntityDescription] =
      AwsError.unwrapOptionField(
        "modelPackageGroupDescription",
        modelPackageGroupDescription
      )
    def getCreationTime: ZIO[Any, Nothing, CreationTime] =
      ZIO.succeed(creationTime)
    def getCreatedBy
        : ZIO[Any, Nothing, zio.aws.sagemaker.model.UserContext.ReadOnly] =
      ZIO.succeed(createdBy)
    def getModelPackageGroupStatus
        : ZIO[Any, Nothing, zio.aws.sagemaker.model.ModelPackageGroupStatus] =
      ZIO.succeed(modelPackageGroupStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeModelPackageGroupResponse
  ) extends zio.aws.sagemaker.model.DescribeModelPackageGroupResponse.ReadOnly {
    override val modelPackageGroupName: EntityName =
      zio.aws.sagemaker.model.primitives
        .EntityName(impl.modelPackageGroupName())
    override val modelPackageGroupArn: ModelPackageGroupArn =
      zio.aws.sagemaker.model.primitives
        .ModelPackageGroupArn(impl.modelPackageGroupArn())
    override val modelPackageGroupDescription: Option[EntityDescription] = scala
      .Option(impl.modelPackageGroupDescription())
      .map(value => zio.aws.sagemaker.model.primitives.EntityDescription(value))
    override val creationTime: CreationTime =
      zio.aws.sagemaker.model.primitives.CreationTime(impl.creationTime())
    override val createdBy: zio.aws.sagemaker.model.UserContext.ReadOnly =
      zio.aws.sagemaker.model.UserContext.wrap(impl.createdBy())
    override val modelPackageGroupStatus
        : zio.aws.sagemaker.model.ModelPackageGroupStatus =
      zio.aws.sagemaker.model.ModelPackageGroupStatus
        .wrap(impl.modelPackageGroupStatus())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeModelPackageGroupResponse
  ): zio.aws.sagemaker.model.DescribeModelPackageGroupResponse.ReadOnly =
    new Wrapper(impl)
}
