package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.sagemaker.model.primitives.{
  ImageDisplayName,
  RoleArn,
  ImageDescription,
  Timestamp,
  FailureReason,
  ImageArn,
  ImageName
}
import scala.jdk.CollectionConverters._
final case class DescribeImageResponse(
    creationTime: Option[Timestamp] = None,
    description: Option[ImageDescription] = None,
    displayName: Option[ImageDisplayName] = None,
    failureReason: Option[FailureReason] = None,
    imageArn: Option[ImageArn] = None,
    imageName: Option[ImageName] = None,
    imageStatus: Option[zio.aws.sagemaker.model.ImageStatus] = None,
    lastModifiedTime: Option[Timestamp] = None,
    roleArn: Option[RoleArn] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.DescribeImageResponse = {
    import DescribeImageResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.DescribeImageResponse
      .builder()
      .optionallyWith(
        creationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(
        description.map(value =>
          ImageDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        displayName.map(value =>
          ImageDisplayName.unwrap(value): java.lang.String
        )
      )(_.displayName)
      .optionallyWith(
        failureReason.map(value =>
          FailureReason.unwrap(value): java.lang.String
        )
      )(_.failureReason)
      .optionallyWith(
        imageArn.map(value => ImageArn.unwrap(value): java.lang.String)
      )(_.imageArn)
      .optionallyWith(
        imageName.map(value => ImageName.unwrap(value): java.lang.String)
      )(_.imageName)
      .optionallyWith(imageStatus.map(value => value.unwrap))(_.imageStatus)
      .optionallyWith(
        lastModifiedTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastModifiedTime)
      .optionallyWith(
        roleArn.map(value => RoleArn.unwrap(value): java.lang.String)
      )(_.roleArn)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.DescribeImageResponse.ReadOnly =
    zio.aws.sagemaker.model.DescribeImageResponse.wrap(buildAwsValue())
}
object DescribeImageResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.DescribeImageResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.DescribeImageResponse =
      zio.aws.sagemaker.model.DescribeImageResponse(
        creationTime.map(value => value),
        description.map(value => value),
        displayName.map(value => value),
        failureReason.map(value => value),
        imageArn.map(value => value),
        imageName.map(value => value),
        imageStatus.map(value => value),
        lastModifiedTime.map(value => value),
        roleArn.map(value => value)
      )
    def creationTime: Option[Timestamp]
    def description: Option[ImageDescription]
    def displayName: Option[ImageDisplayName]
    def failureReason: Option[FailureReason]
    def imageArn: Option[ImageArn]
    def imageName: Option[ImageName]
    def imageStatus: Option[zio.aws.sagemaker.model.ImageStatus]
    def lastModifiedTime: Option[Timestamp]
    def roleArn: Option[RoleArn]
    def getCreationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getDescription: ZIO[Any, AwsError, ImageDescription] =
      AwsError.unwrapOptionField("description", description)
    def getDisplayName: ZIO[Any, AwsError, ImageDisplayName] =
      AwsError.unwrapOptionField("displayName", displayName)
    def getFailureReason: ZIO[Any, AwsError, FailureReason] =
      AwsError.unwrapOptionField("failureReason", failureReason)
    def getImageArn: ZIO[Any, AwsError, ImageArn] =
      AwsError.unwrapOptionField("imageArn", imageArn)
    def getImageName: ZIO[Any, AwsError, ImageName] =
      AwsError.unwrapOptionField("imageName", imageName)
    def getImageStatus
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.ImageStatus] =
      AwsError.unwrapOptionField("imageStatus", imageStatus)
    def getLastModifiedTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastModifiedTime", lastModifiedTime)
    def getRoleArn: ZIO[Any, AwsError, RoleArn] =
      AwsError.unwrapOptionField("roleArn", roleArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeImageResponse
  ) extends zio.aws.sagemaker.model.DescribeImageResponse.ReadOnly {
    override val creationTime: Option[Timestamp] = scala
      .Option(impl.creationTime())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val description: Option[ImageDescription] = scala
      .Option(impl.description())
      .map(value => zio.aws.sagemaker.model.primitives.ImageDescription(value))
    override val displayName: Option[ImageDisplayName] = scala
      .Option(impl.displayName())
      .map(value => zio.aws.sagemaker.model.primitives.ImageDisplayName(value))
    override val failureReason: Option[FailureReason] = scala
      .Option(impl.failureReason())
      .map(value => zio.aws.sagemaker.model.primitives.FailureReason(value))
    override val imageArn: Option[ImageArn] = scala
      .Option(impl.imageArn())
      .map(value => zio.aws.sagemaker.model.primitives.ImageArn(value))
    override val imageName: Option[ImageName] = scala
      .Option(impl.imageName())
      .map(value => zio.aws.sagemaker.model.primitives.ImageName(value))
    override val imageStatus: Option[zio.aws.sagemaker.model.ImageStatus] =
      scala
        .Option(impl.imageStatus())
        .map(value => zio.aws.sagemaker.model.ImageStatus.wrap(value))
    override val lastModifiedTime: Option[Timestamp] = scala
      .Option(impl.lastModifiedTime())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val roleArn: Option[RoleArn] = scala
      .Option(impl.roleArn())
      .map(value => zio.aws.sagemaker.model.primitives.RoleArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeImageResponse
  ): zio.aws.sagemaker.model.DescribeImageResponse.ReadOnly = new Wrapper(impl)
}
