package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sagemaker.model.primitives.{KmsKeyId, EndpointConfigName}
import scala.jdk.CollectionConverters._
final case class CreateEndpointConfigRequest(
    endpointConfigName: EndpointConfigName,
    productionVariants: Iterable[zio.aws.sagemaker.model.ProductionVariant],
    dataCaptureConfig: Option[zio.aws.sagemaker.model.DataCaptureConfig] = None,
    tags: Option[Iterable[zio.aws.sagemaker.model.Tag]] = None,
    kmsKeyId: Option[KmsKeyId] = None,
    asyncInferenceConfig: Option[zio.aws.sagemaker.model.AsyncInferenceConfig] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.CreateEndpointConfigRequest = {
    import CreateEndpointConfigRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.CreateEndpointConfigRequest
      .builder()
      .endpointConfigName(
        EndpointConfigName.unwrap(endpointConfigName): java.lang.String
      )
      .productionVariants(productionVariants.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(dataCaptureConfig.map(value => value.buildAwsValue()))(
        _.dataCaptureConfig
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        kmsKeyId.map(value => KmsKeyId.unwrap(value): java.lang.String)
      )(_.kmsKeyId)
      .optionallyWith(asyncInferenceConfig.map(value => value.buildAwsValue()))(
        _.asyncInferenceConfig
      )
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.CreateEndpointConfigRequest.ReadOnly =
    zio.aws.sagemaker.model.CreateEndpointConfigRequest.wrap(buildAwsValue())
}
object CreateEndpointConfigRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.CreateEndpointConfigRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.CreateEndpointConfigRequest =
      zio.aws.sagemaker.model.CreateEndpointConfigRequest(
        endpointConfigName,
        productionVariants.map { item =>
          item.asEditable
        },
        dataCaptureConfig.map(value => value.asEditable),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        kmsKeyId.map(value => value),
        asyncInferenceConfig.map(value => value.asEditable)
      )
    def endpointConfigName: EndpointConfigName
    def productionVariants
        : List[zio.aws.sagemaker.model.ProductionVariant.ReadOnly]
    def dataCaptureConfig
        : Option[zio.aws.sagemaker.model.DataCaptureConfig.ReadOnly]
    def tags: Option[List[zio.aws.sagemaker.model.Tag.ReadOnly]]
    def kmsKeyId: Option[KmsKeyId]
    def asyncInferenceConfig
        : Option[zio.aws.sagemaker.model.AsyncInferenceConfig.ReadOnly]
    def getEndpointConfigName: ZIO[Any, Nothing, EndpointConfigName] =
      ZIO.succeed(endpointConfigName)
    def getProductionVariants: ZIO[Any, Nothing, List[
      zio.aws.sagemaker.model.ProductionVariant.ReadOnly
    ]] = ZIO.succeed(productionVariants)
    def getDataCaptureConfig: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.DataCaptureConfig.ReadOnly
    ] = AwsError.unwrapOptionField("dataCaptureConfig", dataCaptureConfig)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.sagemaker.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getKmsKeyId: ZIO[Any, AwsError, KmsKeyId] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getAsyncInferenceConfig: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.AsyncInferenceConfig.ReadOnly
    ] = AwsError.unwrapOptionField("asyncInferenceConfig", asyncInferenceConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.CreateEndpointConfigRequest
  ) extends zio.aws.sagemaker.model.CreateEndpointConfigRequest.ReadOnly {
    override val endpointConfigName: EndpointConfigName =
      zio.aws.sagemaker.model.primitives
        .EndpointConfigName(impl.endpointConfigName())
    override val productionVariants
        : List[zio.aws.sagemaker.model.ProductionVariant.ReadOnly] = impl
      .productionVariants()
      .asScala
      .map { item =>
        zio.aws.sagemaker.model.ProductionVariant.wrap(item)
      }
      .toList
    override val dataCaptureConfig
        : Option[zio.aws.sagemaker.model.DataCaptureConfig.ReadOnly] = scala
      .Option(impl.dataCaptureConfig())
      .map(value => zio.aws.sagemaker.model.DataCaptureConfig.wrap(value))
    override val tags: Option[List[zio.aws.sagemaker.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sagemaker.model.Tag.wrap(item)
          }.toList
        )
    override val kmsKeyId: Option[KmsKeyId] = scala
      .Option(impl.kmsKeyId())
      .map(value => zio.aws.sagemaker.model.primitives.KmsKeyId(value))
    override val asyncInferenceConfig
        : Option[zio.aws.sagemaker.model.AsyncInferenceConfig.ReadOnly] = scala
      .Option(impl.asyncInferenceConfig())
      .map(value => zio.aws.sagemaker.model.AsyncInferenceConfig.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.CreateEndpointConfigRequest
  ): zio.aws.sagemaker.model.CreateEndpointConfigRequest.ReadOnly = new Wrapper(
    impl
  )
}
