package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sagemaker.model.primitives.AppImageConfigName
import scala.jdk.CollectionConverters._
final case class CreateAppImageConfigRequest(
    appImageConfigName: AppImageConfigName,
    tags: Option[Iterable[zio.aws.sagemaker.model.Tag]] = None,
    kernelGatewayImageConfig: Option[
      zio.aws.sagemaker.model.KernelGatewayImageConfig
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.CreateAppImageConfigRequest = {
    import CreateAppImageConfigRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.CreateAppImageConfigRequest
      .builder()
      .appImageConfigName(
        AppImageConfigName.unwrap(appImageConfigName): java.lang.String
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        kernelGatewayImageConfig.map(value => value.buildAwsValue())
      )(_.kernelGatewayImageConfig)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.CreateAppImageConfigRequest.ReadOnly =
    zio.aws.sagemaker.model.CreateAppImageConfigRequest.wrap(buildAwsValue())
}
object CreateAppImageConfigRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.CreateAppImageConfigRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.CreateAppImageConfigRequest =
      zio.aws.sagemaker.model.CreateAppImageConfigRequest(
        appImageConfigName,
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        kernelGatewayImageConfig.map(value => value.asEditable)
      )
    def appImageConfigName: AppImageConfigName
    def tags: Option[List[zio.aws.sagemaker.model.Tag.ReadOnly]]
    def kernelGatewayImageConfig
        : Option[zio.aws.sagemaker.model.KernelGatewayImageConfig.ReadOnly]
    def getAppImageConfigName: ZIO[Any, Nothing, AppImageConfigName] =
      ZIO.succeed(appImageConfigName)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.sagemaker.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getKernelGatewayImageConfig: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.KernelGatewayImageConfig.ReadOnly
    ] = AwsError.unwrapOptionField(
      "kernelGatewayImageConfig",
      kernelGatewayImageConfig
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.CreateAppImageConfigRequest
  ) extends zio.aws.sagemaker.model.CreateAppImageConfigRequest.ReadOnly {
    override val appImageConfigName: AppImageConfigName =
      zio.aws.sagemaker.model.primitives
        .AppImageConfigName(impl.appImageConfigName())
    override val tags: Option[List[zio.aws.sagemaker.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sagemaker.model.Tag.wrap(item)
          }.toList
        )
    override val kernelGatewayImageConfig
        : Option[zio.aws.sagemaker.model.KernelGatewayImageConfig.ReadOnly] =
      scala
        .Option(impl.kernelGatewayImageConfig())
        .map(value =>
          zio.aws.sagemaker.model.KernelGatewayImageConfig.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.CreateAppImageConfigRequest
  ): zio.aws.sagemaker.model.CreateAppImageConfigRequest.ReadOnly = new Wrapper(
    impl
  )
}
