package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sagemaker.model.primitives.{S3Uri, ContentDigest, ContentType}
import scala.jdk.CollectionConverters._
final case class MetricsSource(
    contentType: ContentType,
    contentDigest: Option[ContentDigest] = None,
    s3Uri: S3Uri
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.MetricsSource = {
    import MetricsSource.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.MetricsSource
      .builder()
      .contentType(ContentType.unwrap(contentType): java.lang.String)
      .optionallyWith(
        contentDigest.map(value =>
          ContentDigest.unwrap(value): java.lang.String
        )
      )(_.contentDigest)
      .s3Uri(S3Uri.unwrap(s3Uri): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.MetricsSource.ReadOnly =
    zio.aws.sagemaker.model.MetricsSource.wrap(buildAwsValue())
}
object MetricsSource {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.MetricsSource
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.MetricsSource =
      zio.aws.sagemaker.model
        .MetricsSource(contentType, contentDigest.map(value => value), s3Uri)
    def contentType: ContentType
    def contentDigest: Option[ContentDigest]
    def s3Uri: S3Uri
    def getContentType: ZIO[Any, Nothing, ContentType] =
      ZIO.succeed(contentType)
    def getContentDigest: ZIO[Any, AwsError, ContentDigest] =
      AwsError.unwrapOptionField("contentDigest", contentDigest)
    def getS3Uri: ZIO[Any, Nothing, S3Uri] = ZIO.succeed(s3Uri)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.MetricsSource
  ) extends zio.aws.sagemaker.model.MetricsSource.ReadOnly {
    override val contentType: ContentType =
      zio.aws.sagemaker.model.primitives.ContentType(impl.contentType())
    override val contentDigest: Option[ContentDigest] = scala
      .Option(impl.contentDigest())
      .map(value => zio.aws.sagemaker.model.primitives.ContentDigest(value))
    override val s3Uri: S3Uri =
      zio.aws.sagemaker.model.primitives.S3Uri(impl.s3Uri())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.MetricsSource
  ): zio.aws.sagemaker.model.MetricsSource.ReadOnly = new Wrapper(impl)
}
