package zio.aws.sagemaker.model
import zio.aws.sagemaker.model.primitives.{
  NextToken,
  ExperimentEntityName,
  Timestamp,
  MaxResults,
  String256
}
import java.time.Instant
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListTrialComponentsRequest(
    experimentName: Option[ExperimentEntityName] = None,
    trialName: Option[ExperimentEntityName] = None,
    sourceArn: Option[String256] = None,
    createdAfter: Option[Timestamp] = None,
    createdBefore: Option[Timestamp] = None,
    sortBy: Option[zio.aws.sagemaker.model.SortTrialComponentsBy] = None,
    sortOrder: Option[zio.aws.sagemaker.model.SortOrder] = None,
    maxResults: Option[MaxResults] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ListTrialComponentsRequest = {
    import ListTrialComponentsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ListTrialComponentsRequest
      .builder()
      .optionallyWith(
        experimentName.map(value =>
          ExperimentEntityName.unwrap(value): java.lang.String
        )
      )(_.experimentName)
      .optionallyWith(
        trialName.map(value =>
          ExperimentEntityName.unwrap(value): java.lang.String
        )
      )(_.trialName)
      .optionallyWith(
        sourceArn.map(value => String256.unwrap(value): java.lang.String)
      )(_.sourceArn)
      .optionallyWith(
        createdAfter.map(value => Timestamp.unwrap(value): Instant)
      )(_.createdAfter)
      .optionallyWith(
        createdBefore.map(value => Timestamp.unwrap(value): Instant)
      )(_.createdBefore)
      .optionallyWith(sortBy.map(value => value.unwrap))(_.sortBy)
      .optionallyWith(sortOrder.map(value => value.unwrap))(_.sortOrder)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.ListTrialComponentsRequest.ReadOnly =
    zio.aws.sagemaker.model.ListTrialComponentsRequest.wrap(buildAwsValue())
}
object ListTrialComponentsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ListTrialComponentsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ListTrialComponentsRequest =
      zio.aws.sagemaker.model.ListTrialComponentsRequest(
        experimentName.map(value => value),
        trialName.map(value => value),
        sourceArn.map(value => value),
        createdAfter.map(value => value),
        createdBefore.map(value => value),
        sortBy.map(value => value),
        sortOrder.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def experimentName: Option[ExperimentEntityName]
    def trialName: Option[ExperimentEntityName]
    def sourceArn: Option[String256]
    def createdAfter: Option[Timestamp]
    def createdBefore: Option[Timestamp]
    def sortBy: Option[zio.aws.sagemaker.model.SortTrialComponentsBy]
    def sortOrder: Option[zio.aws.sagemaker.model.SortOrder]
    def maxResults: Option[MaxResults]
    def nextToken: Option[NextToken]
    def getExperimentName: ZIO[Any, AwsError, ExperimentEntityName] =
      AwsError.unwrapOptionField("experimentName", experimentName)
    def getTrialName: ZIO[Any, AwsError, ExperimentEntityName] =
      AwsError.unwrapOptionField("trialName", trialName)
    def getSourceArn: ZIO[Any, AwsError, String256] =
      AwsError.unwrapOptionField("sourceArn", sourceArn)
    def getCreatedAfter: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdAfter", createdAfter)
    def getCreatedBefore: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdBefore", createdBefore)
    def getSortBy
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.SortTrialComponentsBy] =
      AwsError.unwrapOptionField("sortBy", sortBy)
    def getSortOrder: ZIO[Any, AwsError, zio.aws.sagemaker.model.SortOrder] =
      AwsError.unwrapOptionField("sortOrder", sortOrder)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ListTrialComponentsRequest
  ) extends zio.aws.sagemaker.model.ListTrialComponentsRequest.ReadOnly {
    override val experimentName: Option[ExperimentEntityName] = scala
      .Option(impl.experimentName())
      .map(value =>
        zio.aws.sagemaker.model.primitives.ExperimentEntityName(value)
      )
    override val trialName: Option[ExperimentEntityName] = scala
      .Option(impl.trialName())
      .map(value =>
        zio.aws.sagemaker.model.primitives.ExperimentEntityName(value)
      )
    override val sourceArn: Option[String256] = scala
      .Option(impl.sourceArn())
      .map(value => zio.aws.sagemaker.model.primitives.String256(value))
    override val createdAfter: Option[Timestamp] = scala
      .Option(impl.createdAfter())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val createdBefore: Option[Timestamp] = scala
      .Option(impl.createdBefore())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val sortBy: Option[zio.aws.sagemaker.model.SortTrialComponentsBy] =
      scala
        .Option(impl.sortBy())
        .map(value => zio.aws.sagemaker.model.SortTrialComponentsBy.wrap(value))
    override val sortOrder: Option[zio.aws.sagemaker.model.SortOrder] = scala
      .Option(impl.sortOrder())
      .map(value => zio.aws.sagemaker.model.SortOrder.wrap(value))
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.sagemaker.model.primitives.MaxResults(value))
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.sagemaker.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ListTrialComponentsRequest
  ): zio.aws.sagemaker.model.ListTrialComponentsRequest.ReadOnly = new Wrapper(
    impl
  )
}
