package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sagemaker.model.primitives.NextToken
import scala.jdk.CollectionConverters._
final case class ListPipelineExecutionsResponse(
    pipelineExecutionSummaries: Option[
      Iterable[zio.aws.sagemaker.model.PipelineExecutionSummary]
    ] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ListPipelineExecutionsResponse = {
    import ListPipelineExecutionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ListPipelineExecutionsResponse
      .builder()
      .optionallyWith(
        pipelineExecutionSummaries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.pipelineExecutionSummaries)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.ListPipelineExecutionsResponse.ReadOnly =
    zio.aws.sagemaker.model.ListPipelineExecutionsResponse.wrap(buildAwsValue())
}
object ListPipelineExecutionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ListPipelineExecutionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ListPipelineExecutionsResponse =
      zio.aws.sagemaker.model.ListPipelineExecutionsResponse(
        pipelineExecutionSummaries.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def pipelineExecutionSummaries: Option[
      List[zio.aws.sagemaker.model.PipelineExecutionSummary.ReadOnly]
    ]
    def nextToken: Option[NextToken]
    def getPipelineExecutionSummaries: ZIO[Any, AwsError, List[
      zio.aws.sagemaker.model.PipelineExecutionSummary.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "pipelineExecutionSummaries",
      pipelineExecutionSummaries
    )
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ListPipelineExecutionsResponse
  ) extends zio.aws.sagemaker.model.ListPipelineExecutionsResponse.ReadOnly {
    override val pipelineExecutionSummaries: Option[
      List[zio.aws.sagemaker.model.PipelineExecutionSummary.ReadOnly]
    ] = scala
      .Option(impl.pipelineExecutionSummaries())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.sagemaker.model.PipelineExecutionSummary.wrap(item)
        }.toList
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.sagemaker.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ListPipelineExecutionsResponse
  ): zio.aws.sagemaker.model.ListPipelineExecutionsResponse.ReadOnly =
    new Wrapper(impl)
}
