package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sagemaker.model.primitives.{MetricValue, MetricName}
import scala.jdk.CollectionConverters._
final case class FinalHyperParameterTuningJobObjectiveMetric(
    `type`: Option[
      zio.aws.sagemaker.model.HyperParameterTuningJobObjectiveType
    ] = None,
    metricName: MetricName,
    value: MetricValue
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.FinalHyperParameterTuningJobObjectiveMetric = {
    import FinalHyperParameterTuningJobObjectiveMetric.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.FinalHyperParameterTuningJobObjectiveMetric
      .builder()
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .metricName(MetricName.unwrap(metricName): java.lang.String)
      .value(MetricValue.unwrap(value): java.lang.Float)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.FinalHyperParameterTuningJobObjectiveMetric.ReadOnly =
    zio.aws.sagemaker.model.FinalHyperParameterTuningJobObjectiveMetric
      .wrap(buildAwsValue())
}
object FinalHyperParameterTuningJobObjectiveMetric {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.FinalHyperParameterTuningJobObjectiveMetric
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.sagemaker.model.FinalHyperParameterTuningJobObjectiveMetric =
      zio.aws.sagemaker.model.FinalHyperParameterTuningJobObjectiveMetric(
        `type`.map(value => value),
        metricName,
        value
      )
    def `type`
        : Option[zio.aws.sagemaker.model.HyperParameterTuningJobObjectiveType]
    def metricName: MetricName
    def value: MetricValue
    def getType: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.HyperParameterTuningJobObjectiveType
    ] = AwsError.unwrapOptionField("type", `type`)
    def getMetricName: ZIO[Any, Nothing, MetricName] = ZIO.succeed(metricName)
    def getValue: ZIO[Any, Nothing, MetricValue] = ZIO.succeed(value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.FinalHyperParameterTuningJobObjectiveMetric
  ) extends zio.aws.sagemaker.model.FinalHyperParameterTuningJobObjectiveMetric.ReadOnly {
    override val `type`
        : Option[zio.aws.sagemaker.model.HyperParameterTuningJobObjectiveType] =
      scala
        .Option(impl.`type`())
        .map(value =>
          zio.aws.sagemaker.model.HyperParameterTuningJobObjectiveType
            .wrap(value)
        )
    override val metricName: MetricName =
      zio.aws.sagemaker.model.primitives.MetricName(impl.metricName())
    override val value: MetricValue =
      zio.aws.sagemaker.model.primitives.MetricValue(impl.value())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.FinalHyperParameterTuningJobObjectiveMetric
  ): zio.aws.sagemaker.model.FinalHyperParameterTuningJobObjectiveMetric.ReadOnly =
    new Wrapper(impl)
}
