package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class Explainability(
    report: Option[zio.aws.sagemaker.model.MetricsSource] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.Explainability = {
    import Explainability.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.Explainability
      .builder()
      .optionallyWith(report.map(value => value.buildAwsValue()))(_.report)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.Explainability.ReadOnly =
    zio.aws.sagemaker.model.Explainability.wrap(buildAwsValue())
}
object Explainability {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.Explainability
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.Explainability =
      zio.aws.sagemaker.model
        .Explainability(report.map(value => value.asEditable))
    def report: Option[zio.aws.sagemaker.model.MetricsSource.ReadOnly]
    def getReport
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.MetricsSource.ReadOnly] =
      AwsError.unwrapOptionField("report", report)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.Explainability
  ) extends zio.aws.sagemaker.model.Explainability.ReadOnly {
    override val report
        : Option[zio.aws.sagemaker.model.MetricsSource.ReadOnly] = scala
      .Option(impl.report())
      .map(value => zio.aws.sagemaker.model.MetricsSource.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.Explainability
  ): zio.aws.sagemaker.model.Explainability.ReadOnly = new Wrapper(impl)
}
