package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sagemaker.model.primitives.{
  ThingName,
  DeviceDescription,
  DeviceName
}
import scala.jdk.CollectionConverters._
final case class Device(
    deviceName: DeviceName,
    description: Option[DeviceDescription] = None,
    iotThingName: Option[ThingName] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.Device = {
    import Device.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.Device
      .builder()
      .deviceName(DeviceName.unwrap(deviceName): java.lang.String)
      .optionallyWith(
        description.map(value =>
          DeviceDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        iotThingName.map(value => ThingName.unwrap(value): java.lang.String)
      )(_.iotThingName)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.Device.ReadOnly =
    zio.aws.sagemaker.model.Device.wrap(buildAwsValue())
}
object Device {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.sagemaker.model.Device] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.Device =
      zio.aws.sagemaker.model.Device(
        deviceName,
        description.map(value => value),
        iotThingName.map(value => value)
      )
    def deviceName: DeviceName
    def description: Option[DeviceDescription]
    def iotThingName: Option[ThingName]
    def getDeviceName: ZIO[Any, Nothing, DeviceName] = ZIO.succeed(deviceName)
    def getDescription: ZIO[Any, AwsError, DeviceDescription] =
      AwsError.unwrapOptionField("description", description)
    def getIotThingName: ZIO[Any, AwsError, ThingName] =
      AwsError.unwrapOptionField("iotThingName", iotThingName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.Device
  ) extends zio.aws.sagemaker.model.Device.ReadOnly {
    override val deviceName: DeviceName =
      zio.aws.sagemaker.model.primitives.DeviceName(impl.deviceName())
    override val description: Option[DeviceDescription] = scala
      .Option(impl.description())
      .map(value => zio.aws.sagemaker.model.primitives.DeviceDescription(value))
    override val iotThingName: Option[ThingName] = scala
      .Option(impl.iotThingName())
      .map(value => zio.aws.sagemaker.model.primitives.ThingName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.Device
  ): zio.aws.sagemaker.model.Device.ReadOnly = new Wrapper(impl)
}
