package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.PipelineExecutionArn
import scala.jdk.CollectionConverters._
final case class DescribePipelineDefinitionForExecutionRequest(
    pipelineExecutionArn: PipelineExecutionArn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.DescribePipelineDefinitionForExecutionRequest = {
    import DescribePipelineDefinitionForExecutionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.DescribePipelineDefinitionForExecutionRequest
      .builder()
      .pipelineExecutionArn(
        PipelineExecutionArn.unwrap(pipelineExecutionArn): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.DescribePipelineDefinitionForExecutionRequest.ReadOnly =
    zio.aws.sagemaker.model.DescribePipelineDefinitionForExecutionRequest
      .wrap(buildAwsValue())
}
object DescribePipelineDefinitionForExecutionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.DescribePipelineDefinitionForExecutionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.sagemaker.model.DescribePipelineDefinitionForExecutionRequest =
      zio.aws.sagemaker.model
        .DescribePipelineDefinitionForExecutionRequest(pipelineExecutionArn)
    def pipelineExecutionArn: PipelineExecutionArn
    def getPipelineExecutionArn: ZIO[Any, Nothing, PipelineExecutionArn] =
      ZIO.succeed(pipelineExecutionArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribePipelineDefinitionForExecutionRequest
  ) extends zio.aws.sagemaker.model.DescribePipelineDefinitionForExecutionRequest.ReadOnly {
    override val pipelineExecutionArn: PipelineExecutionArn =
      zio.aws.sagemaker.model.primitives
        .PipelineExecutionArn(impl.pipelineExecutionArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribePipelineDefinitionForExecutionRequest
  ): zio.aws.sagemaker.model.DescribePipelineDefinitionForExecutionRequest.ReadOnly =
    new Wrapper(impl)
}
