package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.sagemaker.model.primitives.{
  Timestamp,
  AppImageConfigName,
  AppImageConfigArn
}
import scala.jdk.CollectionConverters._
final case class DescribeAppImageConfigResponse(
    appImageConfigArn: Option[AppImageConfigArn] = None,
    appImageConfigName: Option[AppImageConfigName] = None,
    creationTime: Option[Timestamp] = None,
    lastModifiedTime: Option[Timestamp] = None,
    kernelGatewayImageConfig: Option[
      zio.aws.sagemaker.model.KernelGatewayImageConfig
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.DescribeAppImageConfigResponse = {
    import DescribeAppImageConfigResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.DescribeAppImageConfigResponse
      .builder()
      .optionallyWith(
        appImageConfigArn.map(value =>
          AppImageConfigArn.unwrap(value): java.lang.String
        )
      )(_.appImageConfigArn)
      .optionallyWith(
        appImageConfigName.map(value =>
          AppImageConfigName.unwrap(value): java.lang.String
        )
      )(_.appImageConfigName)
      .optionallyWith(
        creationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(
        lastModifiedTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastModifiedTime)
      .optionallyWith(
        kernelGatewayImageConfig.map(value => value.buildAwsValue())
      )(_.kernelGatewayImageConfig)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.DescribeAppImageConfigResponse.ReadOnly =
    zio.aws.sagemaker.model.DescribeAppImageConfigResponse.wrap(buildAwsValue())
}
object DescribeAppImageConfigResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.DescribeAppImageConfigResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.DescribeAppImageConfigResponse =
      zio.aws.sagemaker.model.DescribeAppImageConfigResponse(
        appImageConfigArn.map(value => value),
        appImageConfigName.map(value => value),
        creationTime.map(value => value),
        lastModifiedTime.map(value => value),
        kernelGatewayImageConfig.map(value => value.asEditable)
      )
    def appImageConfigArn: Option[AppImageConfigArn]
    def appImageConfigName: Option[AppImageConfigName]
    def creationTime: Option[Timestamp]
    def lastModifiedTime: Option[Timestamp]
    def kernelGatewayImageConfig
        : Option[zio.aws.sagemaker.model.KernelGatewayImageConfig.ReadOnly]
    def getAppImageConfigArn: ZIO[Any, AwsError, AppImageConfigArn] =
      AwsError.unwrapOptionField("appImageConfigArn", appImageConfigArn)
    def getAppImageConfigName: ZIO[Any, AwsError, AppImageConfigName] =
      AwsError.unwrapOptionField("appImageConfigName", appImageConfigName)
    def getCreationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getLastModifiedTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastModifiedTime", lastModifiedTime)
    def getKernelGatewayImageConfig: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.KernelGatewayImageConfig.ReadOnly
    ] = AwsError.unwrapOptionField(
      "kernelGatewayImageConfig",
      kernelGatewayImageConfig
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeAppImageConfigResponse
  ) extends zio.aws.sagemaker.model.DescribeAppImageConfigResponse.ReadOnly {
    override val appImageConfigArn: Option[AppImageConfigArn] = scala
      .Option(impl.appImageConfigArn())
      .map(value => zio.aws.sagemaker.model.primitives.AppImageConfigArn(value))
    override val appImageConfigName: Option[AppImageConfigName] = scala
      .Option(impl.appImageConfigName())
      .map(value =>
        zio.aws.sagemaker.model.primitives.AppImageConfigName(value)
      )
    override val creationTime: Option[Timestamp] = scala
      .Option(impl.creationTime())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val lastModifiedTime: Option[Timestamp] = scala
      .Option(impl.lastModifiedTime())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val kernelGatewayImageConfig
        : Option[zio.aws.sagemaker.model.KernelGatewayImageConfig.ReadOnly] =
      scala
        .Option(impl.kernelGatewayImageConfig())
        .map(value =>
          zio.aws.sagemaker.model.KernelGatewayImageConfig.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeAppImageConfigResponse
  ): zio.aws.sagemaker.model.DescribeAppImageConfigResponse.ReadOnly =
    new Wrapper(impl)
}
