package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sagemaker.model.primitives.AssociationEntityArn
import scala.jdk.CollectionConverters._
final case class DeleteAssociationResponse(
    sourceArn: Option[AssociationEntityArn] = None,
    destinationArn: Option[AssociationEntityArn] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.DeleteAssociationResponse = {
    import DeleteAssociationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.DeleteAssociationResponse
      .builder()
      .optionallyWith(
        sourceArn.map(value =>
          AssociationEntityArn.unwrap(value): java.lang.String
        )
      )(_.sourceArn)
      .optionallyWith(
        destinationArn.map(value =>
          AssociationEntityArn.unwrap(value): java.lang.String
        )
      )(_.destinationArn)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.DeleteAssociationResponse.ReadOnly =
    zio.aws.sagemaker.model.DeleteAssociationResponse.wrap(buildAwsValue())
}
object DeleteAssociationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.DeleteAssociationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.DeleteAssociationResponse =
      zio.aws.sagemaker.model.DeleteAssociationResponse(
        sourceArn.map(value => value),
        destinationArn.map(value => value)
      )
    def sourceArn: Option[AssociationEntityArn]
    def destinationArn: Option[AssociationEntityArn]
    def getSourceArn: ZIO[Any, AwsError, AssociationEntityArn] =
      AwsError.unwrapOptionField("sourceArn", sourceArn)
    def getDestinationArn: ZIO[Any, AwsError, AssociationEntityArn] =
      AwsError.unwrapOptionField("destinationArn", destinationArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.DeleteAssociationResponse
  ) extends zio.aws.sagemaker.model.DeleteAssociationResponse.ReadOnly {
    override val sourceArn: Option[AssociationEntityArn] = scala
      .Option(impl.sourceArn())
      .map(value =>
        zio.aws.sagemaker.model.primitives.AssociationEntityArn(value)
      )
    override val destinationArn: Option[AssociationEntityArn] = scala
      .Option(impl.destinationArn())
      .map(value =>
        zio.aws.sagemaker.model.primitives.AssociationEntityArn(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.DeleteAssociationResponse
  ): zio.aws.sagemaker.model.DeleteAssociationResponse.ReadOnly = new Wrapper(
    impl
  )
}
