package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.ProcessingJobArn
import scala.jdk.CollectionConverters._
final case class CreateProcessingJobResponse(
    processingJobArn: ProcessingJobArn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.CreateProcessingJobResponse = {
    import CreateProcessingJobResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.CreateProcessingJobResponse
      .builder()
      .processingJobArn(
        ProcessingJobArn.unwrap(processingJobArn): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.CreateProcessingJobResponse.ReadOnly =
    zio.aws.sagemaker.model.CreateProcessingJobResponse.wrap(buildAwsValue())
}
object CreateProcessingJobResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.CreateProcessingJobResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.CreateProcessingJobResponse =
      zio.aws.sagemaker.model.CreateProcessingJobResponse(processingJobArn)
    def processingJobArn: ProcessingJobArn
    def getProcessingJobArn: ZIO[Any, Nothing, ProcessingJobArn] =
      ZIO.succeed(processingJobArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.CreateProcessingJobResponse
  ) extends zio.aws.sagemaker.model.CreateProcessingJobResponse.ReadOnly {
    override val processingJobArn: ProcessingJobArn =
      zio.aws.sagemaker.model.primitives
        .ProcessingJobArn(impl.processingJobArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.CreateProcessingJobResponse
  ): zio.aws.sagemaker.model.CreateProcessingJobResponse.ReadOnly = new Wrapper(
    impl
  )
}
