package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sagemaker.model.primitives.KmsKeyId
import scala.jdk.CollectionConverters._
final case class AutoMLSecurityConfig(
    volumeKmsKeyId: Option[KmsKeyId] = None,
    enableInterContainerTrafficEncryption: Option[Boolean] = None,
    vpcConfig: Option[zio.aws.sagemaker.model.VpcConfig] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.AutoMLSecurityConfig = {
    import AutoMLSecurityConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.AutoMLSecurityConfig
      .builder()
      .optionallyWith(
        volumeKmsKeyId.map(value => KmsKeyId.unwrap(value): java.lang.String)
      )(_.volumeKmsKeyId)
      .optionallyWith(
        enableInterContainerTrafficEncryption.map(value =>
          value: java.lang.Boolean
        )
      )(_.enableInterContainerTrafficEncryption)
      .optionallyWith(vpcConfig.map(value => value.buildAwsValue()))(
        _.vpcConfig
      )
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.AutoMLSecurityConfig.ReadOnly =
    zio.aws.sagemaker.model.AutoMLSecurityConfig.wrap(buildAwsValue())
}
object AutoMLSecurityConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.AutoMLSecurityConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.AutoMLSecurityConfig =
      zio.aws.sagemaker.model.AutoMLSecurityConfig(
        volumeKmsKeyId.map(value => value),
        enableInterContainerTrafficEncryption.map(value => value),
        vpcConfig.map(value => value.asEditable)
      )
    def volumeKmsKeyId: Option[KmsKeyId]
    def enableInterContainerTrafficEncryption: Option[Boolean]
    def vpcConfig: Option[zio.aws.sagemaker.model.VpcConfig.ReadOnly]
    def getVolumeKmsKeyId: ZIO[Any, AwsError, KmsKeyId] =
      AwsError.unwrapOptionField("volumeKmsKeyId", volumeKmsKeyId)
    def getEnableInterContainerTrafficEncryption: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField(
        "enableInterContainerTrafficEncryption",
        enableInterContainerTrafficEncryption
      )
    def getVpcConfig
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.VpcConfig.ReadOnly] =
      AwsError.unwrapOptionField("vpcConfig", vpcConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.AutoMLSecurityConfig
  ) extends zio.aws.sagemaker.model.AutoMLSecurityConfig.ReadOnly {
    override val volumeKmsKeyId: Option[KmsKeyId] = scala
      .Option(impl.volumeKmsKeyId())
      .map(value => zio.aws.sagemaker.model.primitives.KmsKeyId(value))
    override val enableInterContainerTrafficEncryption: Option[Boolean] = scala
      .Option(impl.enableInterContainerTrafficEncryption())
      .map(value => value: Boolean)
    override val vpcConfig: Option[zio.aws.sagemaker.model.VpcConfig.ReadOnly] =
      scala
        .Option(impl.vpcConfig())
        .map(value => zio.aws.sagemaker.model.VpcConfig.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.AutoMLSecurityConfig
  ): zio.aws.sagemaker.model.AutoMLSecurityConfig.ReadOnly = new Wrapper(impl)
}
