package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sagemaker.model.primitives.{
  RoleArn,
  PipelineDescription,
  PipelineDefinition,
  PipelineName
}
import scala.jdk.CollectionConverters._
final case class UpdatePipelineRequest(
    pipelineName: PipelineName,
    pipelineDisplayName: Option[PipelineName] = None,
    pipelineDefinition: Option[PipelineDefinition] = None,
    pipelineDefinitionS3Location: Option[
      zio.aws.sagemaker.model.PipelineDefinitionS3Location
    ] = None,
    pipelineDescription: Option[PipelineDescription] = None,
    roleArn: Option[RoleArn] = None,
    parallelismConfiguration: Option[
      zio.aws.sagemaker.model.ParallelismConfiguration
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.UpdatePipelineRequest = {
    import UpdatePipelineRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.UpdatePipelineRequest
      .builder()
      .pipelineName(PipelineName.unwrap(pipelineName): java.lang.String)
      .optionallyWith(
        pipelineDisplayName.map(value =>
          PipelineName.unwrap(value): java.lang.String
        )
      )(_.pipelineDisplayName)
      .optionallyWith(
        pipelineDefinition.map(value =>
          PipelineDefinition.unwrap(value): java.lang.String
        )
      )(_.pipelineDefinition)
      .optionallyWith(
        pipelineDefinitionS3Location.map(value => value.buildAwsValue())
      )(_.pipelineDefinitionS3Location)
      .optionallyWith(
        pipelineDescription.map(value =>
          PipelineDescription.unwrap(value): java.lang.String
        )
      )(_.pipelineDescription)
      .optionallyWith(
        roleArn.map(value => RoleArn.unwrap(value): java.lang.String)
      )(_.roleArn)
      .optionallyWith(
        parallelismConfiguration.map(value => value.buildAwsValue())
      )(_.parallelismConfiguration)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.UpdatePipelineRequest.ReadOnly =
    zio.aws.sagemaker.model.UpdatePipelineRequest.wrap(buildAwsValue())
}
object UpdatePipelineRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.UpdatePipelineRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.UpdatePipelineRequest =
      zio.aws.sagemaker.model.UpdatePipelineRequest(
        pipelineName,
        pipelineDisplayName.map(value => value),
        pipelineDefinition.map(value => value),
        pipelineDefinitionS3Location.map(value => value.asEditable),
        pipelineDescription.map(value => value),
        roleArn.map(value => value),
        parallelismConfiguration.map(value => value.asEditable)
      )
    def pipelineName: PipelineName
    def pipelineDisplayName: Option[PipelineName]
    def pipelineDefinition: Option[PipelineDefinition]
    def pipelineDefinitionS3Location
        : Option[zio.aws.sagemaker.model.PipelineDefinitionS3Location.ReadOnly]
    def pipelineDescription: Option[PipelineDescription]
    def roleArn: Option[RoleArn]
    def parallelismConfiguration
        : Option[zio.aws.sagemaker.model.ParallelismConfiguration.ReadOnly]
    def getPipelineName: ZIO[Any, Nothing, PipelineName] =
      ZIO.succeed(pipelineName)
    def getPipelineDisplayName: ZIO[Any, AwsError, PipelineName] =
      AwsError.unwrapOptionField("pipelineDisplayName", pipelineDisplayName)
    def getPipelineDefinition: ZIO[Any, AwsError, PipelineDefinition] =
      AwsError.unwrapOptionField("pipelineDefinition", pipelineDefinition)
    def getPipelineDefinitionS3Location: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.PipelineDefinitionS3Location.ReadOnly
    ] = AwsError.unwrapOptionField(
      "pipelineDefinitionS3Location",
      pipelineDefinitionS3Location
    )
    def getPipelineDescription: ZIO[Any, AwsError, PipelineDescription] =
      AwsError.unwrapOptionField("pipelineDescription", pipelineDescription)
    def getRoleArn: ZIO[Any, AwsError, RoleArn] =
      AwsError.unwrapOptionField("roleArn", roleArn)
    def getParallelismConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.ParallelismConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "parallelismConfiguration",
      parallelismConfiguration
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.UpdatePipelineRequest
  ) extends zio.aws.sagemaker.model.UpdatePipelineRequest.ReadOnly {
    override val pipelineName: PipelineName =
      zio.aws.sagemaker.model.primitives.PipelineName(impl.pipelineName())
    override val pipelineDisplayName: Option[PipelineName] = scala
      .Option(impl.pipelineDisplayName())
      .map(value => zio.aws.sagemaker.model.primitives.PipelineName(value))
    override val pipelineDefinition: Option[PipelineDefinition] = scala
      .Option(impl.pipelineDefinition())
      .map(value =>
        zio.aws.sagemaker.model.primitives.PipelineDefinition(value)
      )
    override val pipelineDefinitionS3Location: Option[
      zio.aws.sagemaker.model.PipelineDefinitionS3Location.ReadOnly
    ] = scala
      .Option(impl.pipelineDefinitionS3Location())
      .map(value =>
        zio.aws.sagemaker.model.PipelineDefinitionS3Location.wrap(value)
      )
    override val pipelineDescription: Option[PipelineDescription] = scala
      .Option(impl.pipelineDescription())
      .map(value =>
        zio.aws.sagemaker.model.primitives.PipelineDescription(value)
      )
    override val roleArn: Option[RoleArn] = scala
      .Option(impl.roleArn())
      .map(value => zio.aws.sagemaker.model.primitives.RoleArn(value))
    override val parallelismConfiguration
        : Option[zio.aws.sagemaker.model.ParallelismConfiguration.ReadOnly] =
      scala
        .Option(impl.parallelismConfiguration())
        .map(value =>
          zio.aws.sagemaker.model.ParallelismConfiguration.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.UpdatePipelineRequest
  ): zio.aws.sagemaker.model.UpdatePipelineRequest.ReadOnly = new Wrapper(impl)
}
