package zio.aws.sagemaker.model
import zio.aws.sagemaker.model.primitives.{
  MetricName,
  OptionalDouble,
  Timestamp,
  OptionalInteger,
  TrialComponentSourceArn
}
import java.time.Instant
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class TrialComponentMetricSummary(
    metricName: Option[MetricName] = None,
    sourceArn: Option[TrialComponentSourceArn] = None,
    timeStamp: Option[Timestamp] = None,
    max: Option[OptionalDouble] = None,
    min: Option[OptionalDouble] = None,
    last: Option[OptionalDouble] = None,
    count: Option[OptionalInteger] = None,
    avg: Option[OptionalDouble] = None,
    stdDev: Option[OptionalDouble] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.TrialComponentMetricSummary = {
    import TrialComponentMetricSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.TrialComponentMetricSummary
      .builder()
      .optionallyWith(
        metricName.map(value => MetricName.unwrap(value): java.lang.String)
      )(_.metricName)
      .optionallyWith(
        sourceArn.map(value =>
          TrialComponentSourceArn.unwrap(value): java.lang.String
        )
      )(_.sourceArn)
      .optionallyWith(timeStamp.map(value => Timestamp.unwrap(value): Instant))(
        _.timeStamp
      )
      .optionallyWith(
        max.map(value => OptionalDouble.unwrap(value): java.lang.Double)
      )(_.max)
      .optionallyWith(
        min.map(value => OptionalDouble.unwrap(value): java.lang.Double)
      )(_.min)
      .optionallyWith(
        last.map(value => OptionalDouble.unwrap(value): java.lang.Double)
      )(_.last)
      .optionallyWith(
        count.map(value => OptionalInteger.unwrap(value): Integer)
      )(_.count)
      .optionallyWith(
        avg.map(value => OptionalDouble.unwrap(value): java.lang.Double)
      )(_.avg)
      .optionallyWith(
        stdDev.map(value => OptionalDouble.unwrap(value): java.lang.Double)
      )(_.stdDev)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.TrialComponentMetricSummary.ReadOnly =
    zio.aws.sagemaker.model.TrialComponentMetricSummary.wrap(buildAwsValue())
}
object TrialComponentMetricSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.TrialComponentMetricSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.TrialComponentMetricSummary =
      zio.aws.sagemaker.model.TrialComponentMetricSummary(
        metricName.map(value => value),
        sourceArn.map(value => value),
        timeStamp.map(value => value),
        max.map(value => value),
        min.map(value => value),
        last.map(value => value),
        count.map(value => value),
        avg.map(value => value),
        stdDev.map(value => value)
      )
    def metricName: Option[MetricName]
    def sourceArn: Option[TrialComponentSourceArn]
    def timeStamp: Option[Timestamp]
    def max: Option[OptionalDouble]
    def min: Option[OptionalDouble]
    def last: Option[OptionalDouble]
    def count: Option[OptionalInteger]
    def avg: Option[OptionalDouble]
    def stdDev: Option[OptionalDouble]
    def getMetricName: ZIO[Any, AwsError, MetricName] =
      AwsError.unwrapOptionField("metricName", metricName)
    def getSourceArn: ZIO[Any, AwsError, TrialComponentSourceArn] =
      AwsError.unwrapOptionField("sourceArn", sourceArn)
    def getTimeStamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("timeStamp", timeStamp)
    def getMax: ZIO[Any, AwsError, OptionalDouble] =
      AwsError.unwrapOptionField("max", max)
    def getMin: ZIO[Any, AwsError, OptionalDouble] =
      AwsError.unwrapOptionField("min", min)
    def getLast: ZIO[Any, AwsError, OptionalDouble] =
      AwsError.unwrapOptionField("last", last)
    def getCount: ZIO[Any, AwsError, OptionalInteger] =
      AwsError.unwrapOptionField("count", count)
    def getAvg: ZIO[Any, AwsError, OptionalDouble] =
      AwsError.unwrapOptionField("avg", avg)
    def getStdDev: ZIO[Any, AwsError, OptionalDouble] =
      AwsError.unwrapOptionField("stdDev", stdDev)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.TrialComponentMetricSummary
  ) extends zio.aws.sagemaker.model.TrialComponentMetricSummary.ReadOnly {
    override val metricName: Option[MetricName] = scala
      .Option(impl.metricName())
      .map(value => zio.aws.sagemaker.model.primitives.MetricName(value))
    override val sourceArn: Option[TrialComponentSourceArn] = scala
      .Option(impl.sourceArn())
      .map(value =>
        zio.aws.sagemaker.model.primitives.TrialComponentSourceArn(value)
      )
    override val timeStamp: Option[Timestamp] = scala
      .Option(impl.timeStamp())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val max: Option[OptionalDouble] = scala
      .Option(impl.max())
      .map(value => zio.aws.sagemaker.model.primitives.OptionalDouble(value))
    override val min: Option[OptionalDouble] = scala
      .Option(impl.min())
      .map(value => zio.aws.sagemaker.model.primitives.OptionalDouble(value))
    override val last: Option[OptionalDouble] = scala
      .Option(impl.last())
      .map(value => zio.aws.sagemaker.model.primitives.OptionalDouble(value))
    override val count: Option[OptionalInteger] = scala
      .Option(impl.count())
      .map(value => zio.aws.sagemaker.model.primitives.OptionalInteger(value))
    override val avg: Option[OptionalDouble] = scala
      .Option(impl.avg())
      .map(value => zio.aws.sagemaker.model.primitives.OptionalDouble(value))
    override val stdDev: Option[OptionalDouble] = scala
      .Option(impl.stdDev())
      .map(value => zio.aws.sagemaker.model.primitives.OptionalDouble(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.TrialComponentMetricSummary
  ): zio.aws.sagemaker.model.TrialComponentMetricSummary.ReadOnly = new Wrapper(
    impl
  )
}
