package zio.aws.sagemaker.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sagemaker.model.primitives.{
  TransformEnvironmentValue,
  TransformEnvironmentKey,
  MaxPayloadInMB,
  MaxConcurrentTransforms
}
import scala.jdk.CollectionConverters._
final case class TransformJobDefinition(
    maxConcurrentTransforms: Option[MaxConcurrentTransforms] = None,
    maxPayloadInMB: Option[MaxPayloadInMB] = None,
    batchStrategy: Option[zio.aws.sagemaker.model.BatchStrategy] = None,
    environment: Option[
      Map[TransformEnvironmentKey, TransformEnvironmentValue]
    ] = None,
    transformInput: zio.aws.sagemaker.model.TransformInput,
    transformOutput: zio.aws.sagemaker.model.TransformOutput,
    transformResources: zio.aws.sagemaker.model.TransformResources
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.TransformJobDefinition = {
    import TransformJobDefinition.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.TransformJobDefinition
      .builder()
      .optionallyWith(
        maxConcurrentTransforms.map(value =>
          MaxConcurrentTransforms.unwrap(value): Integer
        )
      )(_.maxConcurrentTransforms)
      .optionallyWith(
        maxPayloadInMB.map(value => MaxPayloadInMB.unwrap(value): Integer)
      )(_.maxPayloadInMB)
      .optionallyWith(batchStrategy.map(value => value.unwrap))(_.batchStrategy)
      .optionallyWith(
        environment.map(value =>
          value
            .map({ case (key, value) =>
              (TransformEnvironmentKey.unwrap(
                key
              ): java.lang.String) -> (TransformEnvironmentValue.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.environment)
      .transformInput(transformInput.buildAwsValue())
      .transformOutput(transformOutput.buildAwsValue())
      .transformResources(transformResources.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.TransformJobDefinition.ReadOnly =
    zio.aws.sagemaker.model.TransformJobDefinition.wrap(buildAwsValue())
}
object TransformJobDefinition {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.TransformJobDefinition
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.TransformJobDefinition =
      zio.aws.sagemaker.model.TransformJobDefinition(
        maxConcurrentTransforms.map(value => value),
        maxPayloadInMB.map(value => value),
        batchStrategy.map(value => value),
        environment.map(value => value),
        transformInput.asEditable,
        transformOutput.asEditable,
        transformResources.asEditable
      )
    def maxConcurrentTransforms: Option[MaxConcurrentTransforms]
    def maxPayloadInMB: Option[MaxPayloadInMB]
    def batchStrategy: Option[zio.aws.sagemaker.model.BatchStrategy]
    def environment
        : Option[Map[TransformEnvironmentKey, TransformEnvironmentValue]]
    def transformInput: zio.aws.sagemaker.model.TransformInput.ReadOnly
    def transformOutput: zio.aws.sagemaker.model.TransformOutput.ReadOnly
    def transformResources: zio.aws.sagemaker.model.TransformResources.ReadOnly
    def getMaxConcurrentTransforms
        : ZIO[Any, AwsError, MaxConcurrentTransforms] = AwsError
      .unwrapOptionField("maxConcurrentTransforms", maxConcurrentTransforms)
    def getMaxPayloadInMB: ZIO[Any, AwsError, MaxPayloadInMB] =
      AwsError.unwrapOptionField("maxPayloadInMB", maxPayloadInMB)
    def getBatchStrategy
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.BatchStrategy] =
      AwsError.unwrapOptionField("batchStrategy", batchStrategy)
    def getEnvironment: ZIO[Any, AwsError, Map[
      TransformEnvironmentKey,
      TransformEnvironmentValue
    ]] = AwsError.unwrapOptionField("environment", environment)
    def getTransformInput
        : ZIO[Any, Nothing, zio.aws.sagemaker.model.TransformInput.ReadOnly] =
      ZIO.succeed(transformInput)
    def getTransformOutput
        : ZIO[Any, Nothing, zio.aws.sagemaker.model.TransformOutput.ReadOnly] =
      ZIO.succeed(transformOutput)
    def getTransformResources: ZIO[
      Any,
      Nothing,
      zio.aws.sagemaker.model.TransformResources.ReadOnly
    ] = ZIO.succeed(transformResources)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.TransformJobDefinition
  ) extends zio.aws.sagemaker.model.TransformJobDefinition.ReadOnly {
    override val maxConcurrentTransforms: Option[MaxConcurrentTransforms] =
      scala
        .Option(impl.maxConcurrentTransforms())
        .map(value =>
          zio.aws.sagemaker.model.primitives.MaxConcurrentTransforms(value)
        )
    override val maxPayloadInMB: Option[MaxPayloadInMB] = scala
      .Option(impl.maxPayloadInMB())
      .map(value => zio.aws.sagemaker.model.primitives.MaxPayloadInMB(value))
    override val batchStrategy: Option[zio.aws.sagemaker.model.BatchStrategy] =
      scala
        .Option(impl.batchStrategy())
        .map(value => zio.aws.sagemaker.model.BatchStrategy.wrap(value))
    override val environment
        : Option[Map[TransformEnvironmentKey, TransformEnvironmentValue]] =
      scala
        .Option(impl.environment())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.sagemaker.model.primitives.TransformEnvironmentKey(
                key
              ) -> zio.aws.sagemaker.model.primitives
                .TransformEnvironmentValue(value)
            })
            .toMap
        )
    override val transformInput
        : zio.aws.sagemaker.model.TransformInput.ReadOnly =
      zio.aws.sagemaker.model.TransformInput.wrap(impl.transformInput())
    override val transformOutput
        : zio.aws.sagemaker.model.TransformOutput.ReadOnly =
      zio.aws.sagemaker.model.TransformOutput.wrap(impl.transformOutput())
    override val transformResources
        : zio.aws.sagemaker.model.TransformResources.ReadOnly =
      zio.aws.sagemaker.model.TransformResources.wrap(impl.transformResources())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.TransformJobDefinition
  ): zio.aws.sagemaker.model.TransformJobDefinition.ReadOnly = new Wrapper(impl)
}
