package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.ScheduleExpression
import scala.jdk.CollectionConverters._
final case class ScheduleConfig(scheduleExpression: ScheduleExpression) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ScheduleConfig = {
    import ScheduleConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ScheduleConfig
      .builder()
      .scheduleExpression(
        ScheduleExpression.unwrap(scheduleExpression): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.ScheduleConfig.ReadOnly =
    zio.aws.sagemaker.model.ScheduleConfig.wrap(buildAwsValue())
}
object ScheduleConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ScheduleConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ScheduleConfig =
      zio.aws.sagemaker.model.ScheduleConfig(scheduleExpression)
    def scheduleExpression: ScheduleExpression
    def getScheduleExpression: ZIO[Any, Nothing, ScheduleExpression] =
      ZIO.succeed(scheduleExpression)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ScheduleConfig
  ) extends zio.aws.sagemaker.model.ScheduleConfig.ReadOnly {
    override val scheduleExpression: ScheduleExpression =
      zio.aws.sagemaker.model.primitives
        .ScheduleExpression(impl.scheduleExpression())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ScheduleConfig
  ): zio.aws.sagemaker.model.ScheduleConfig.ReadOnly = new Wrapper(impl)
}
