package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.{PolicyString, EntityName}
import scala.jdk.CollectionConverters._
final case class PutModelPackageGroupPolicyRequest(
    modelPackageGroupName: EntityName,
    resourcePolicy: PolicyString
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.PutModelPackageGroupPolicyRequest = {
    import PutModelPackageGroupPolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.PutModelPackageGroupPolicyRequest
      .builder()
      .modelPackageGroupName(
        EntityName.unwrap(modelPackageGroupName): java.lang.String
      )
      .resourcePolicy(PolicyString.unwrap(resourcePolicy): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.PutModelPackageGroupPolicyRequest.ReadOnly =
    zio.aws.sagemaker.model.PutModelPackageGroupPolicyRequest
      .wrap(buildAwsValue())
}
object PutModelPackageGroupPolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.PutModelPackageGroupPolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.PutModelPackageGroupPolicyRequest =
      zio.aws.sagemaker.model.PutModelPackageGroupPolicyRequest(
        modelPackageGroupName,
        resourcePolicy
      )
    def modelPackageGroupName: EntityName
    def resourcePolicy: PolicyString
    def getModelPackageGroupName: ZIO[Any, Nothing, EntityName] =
      ZIO.succeed(modelPackageGroupName)
    def getResourcePolicy: ZIO[Any, Nothing, PolicyString] =
      ZIO.succeed(resourcePolicy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.PutModelPackageGroupPolicyRequest
  ) extends zio.aws.sagemaker.model.PutModelPackageGroupPolicyRequest.ReadOnly {
    override val modelPackageGroupName: EntityName =
      zio.aws.sagemaker.model.primitives
        .EntityName(impl.modelPackageGroupName())
    override val resourcePolicy: PolicyString =
      zio.aws.sagemaker.model.primitives.PolicyString(impl.resourcePolicy())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.PutModelPackageGroupPolicyRequest
  ): zio.aws.sagemaker.model.PutModelPackageGroupPolicyRequest.ReadOnly =
    new Wrapper(impl)
}
