package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.sagemaker.model.primitives.{
  ProjectEntityName,
  ProjectId,
  Timestamp,
  ProjectArn,
  EntityDescription
}
import scala.jdk.CollectionConverters._
final case class Project(
    projectArn: Option[ProjectArn] = None,
    projectName: Option[ProjectEntityName] = None,
    projectId: Option[ProjectId] = None,
    projectDescription: Option[EntityDescription] = None,
    serviceCatalogProvisioningDetails: Option[
      zio.aws.sagemaker.model.ServiceCatalogProvisioningDetails
    ] = None,
    serviceCatalogProvisionedProductDetails: Option[
      zio.aws.sagemaker.model.ServiceCatalogProvisionedProductDetails
    ] = None,
    projectStatus: Option[zio.aws.sagemaker.model.ProjectStatus] = None,
    createdBy: Option[zio.aws.sagemaker.model.UserContext] = None,
    creationTime: Option[Timestamp] = None,
    tags: Option[Iterable[zio.aws.sagemaker.model.Tag]] = None,
    lastModifiedTime: Option[Timestamp] = None,
    lastModifiedBy: Option[zio.aws.sagemaker.model.UserContext] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.Project = {
    import Project.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.Project
      .builder()
      .optionallyWith(
        projectArn.map(value => ProjectArn.unwrap(value): java.lang.String)
      )(_.projectArn)
      .optionallyWith(
        projectName.map(value =>
          ProjectEntityName.unwrap(value): java.lang.String
        )
      )(_.projectName)
      .optionallyWith(
        projectId.map(value => ProjectId.unwrap(value): java.lang.String)
      )(_.projectId)
      .optionallyWith(
        projectDescription.map(value =>
          EntityDescription.unwrap(value): java.lang.String
        )
      )(_.projectDescription)
      .optionallyWith(
        serviceCatalogProvisioningDetails.map(value => value.buildAwsValue())
      )(_.serviceCatalogProvisioningDetails)
      .optionallyWith(
        serviceCatalogProvisionedProductDetails.map(value =>
          value.buildAwsValue()
        )
      )(_.serviceCatalogProvisionedProductDetails)
      .optionallyWith(projectStatus.map(value => value.unwrap))(_.projectStatus)
      .optionallyWith(createdBy.map(value => value.buildAwsValue()))(
        _.createdBy
      )
      .optionallyWith(
        creationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        lastModifiedTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastModifiedTime)
      .optionallyWith(lastModifiedBy.map(value => value.buildAwsValue()))(
        _.lastModifiedBy
      )
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.Project.ReadOnly =
    zio.aws.sagemaker.model.Project.wrap(buildAwsValue())
}
object Project {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.sagemaker.model.Project] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.Project =
      zio.aws.sagemaker.model.Project(
        projectArn.map(value => value),
        projectName.map(value => value),
        projectId.map(value => value),
        projectDescription.map(value => value),
        serviceCatalogProvisioningDetails.map(value => value.asEditable),
        serviceCatalogProvisionedProductDetails.map(value => value.asEditable),
        projectStatus.map(value => value),
        createdBy.map(value => value.asEditable),
        creationTime.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        lastModifiedTime.map(value => value),
        lastModifiedBy.map(value => value.asEditable)
      )
    def projectArn: Option[ProjectArn]
    def projectName: Option[ProjectEntityName]
    def projectId: Option[ProjectId]
    def projectDescription: Option[EntityDescription]
    def serviceCatalogProvisioningDetails: Option[
      zio.aws.sagemaker.model.ServiceCatalogProvisioningDetails.ReadOnly
    ]
    def serviceCatalogProvisionedProductDetails: Option[
      zio.aws.sagemaker.model.ServiceCatalogProvisionedProductDetails.ReadOnly
    ]
    def projectStatus: Option[zio.aws.sagemaker.model.ProjectStatus]
    def createdBy: Option[zio.aws.sagemaker.model.UserContext.ReadOnly]
    def creationTime: Option[Timestamp]
    def tags: Option[List[zio.aws.sagemaker.model.Tag.ReadOnly]]
    def lastModifiedTime: Option[Timestamp]
    def lastModifiedBy: Option[zio.aws.sagemaker.model.UserContext.ReadOnly]
    def getProjectArn: ZIO[Any, AwsError, ProjectArn] =
      AwsError.unwrapOptionField("projectArn", projectArn)
    def getProjectName: ZIO[Any, AwsError, ProjectEntityName] =
      AwsError.unwrapOptionField("projectName", projectName)
    def getProjectId: ZIO[Any, AwsError, ProjectId] =
      AwsError.unwrapOptionField("projectId", projectId)
    def getProjectDescription: ZIO[Any, AwsError, EntityDescription] =
      AwsError.unwrapOptionField("projectDescription", projectDescription)
    def getServiceCatalogProvisioningDetails: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.ServiceCatalogProvisioningDetails.ReadOnly
    ] = AwsError.unwrapOptionField(
      "serviceCatalogProvisioningDetails",
      serviceCatalogProvisioningDetails
    )
    def getServiceCatalogProvisionedProductDetails: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.ServiceCatalogProvisionedProductDetails.ReadOnly
    ] = AwsError.unwrapOptionField(
      "serviceCatalogProvisionedProductDetails",
      serviceCatalogProvisionedProductDetails
    )
    def getProjectStatus
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.ProjectStatus] =
      AwsError.unwrapOptionField("projectStatus", projectStatus)
    def getCreatedBy
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.UserContext.ReadOnly] =
      AwsError.unwrapOptionField("createdBy", createdBy)
    def getCreationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.sagemaker.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getLastModifiedTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastModifiedTime", lastModifiedTime)
    def getLastModifiedBy
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.UserContext.ReadOnly] =
      AwsError.unwrapOptionField("lastModifiedBy", lastModifiedBy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.Project
  ) extends zio.aws.sagemaker.model.Project.ReadOnly {
    override val projectArn: Option[ProjectArn] = scala
      .Option(impl.projectArn())
      .map(value => zio.aws.sagemaker.model.primitives.ProjectArn(value))
    override val projectName: Option[ProjectEntityName] = scala
      .Option(impl.projectName())
      .map(value => zio.aws.sagemaker.model.primitives.ProjectEntityName(value))
    override val projectId: Option[ProjectId] = scala
      .Option(impl.projectId())
      .map(value => zio.aws.sagemaker.model.primitives.ProjectId(value))
    override val projectDescription: Option[EntityDescription] = scala
      .Option(impl.projectDescription())
      .map(value => zio.aws.sagemaker.model.primitives.EntityDescription(value))
    override val serviceCatalogProvisioningDetails: Option[
      zio.aws.sagemaker.model.ServiceCatalogProvisioningDetails.ReadOnly
    ] = scala
      .Option(impl.serviceCatalogProvisioningDetails())
      .map(value =>
        zio.aws.sagemaker.model.ServiceCatalogProvisioningDetails.wrap(value)
      )
    override val serviceCatalogProvisionedProductDetails: Option[
      zio.aws.sagemaker.model.ServiceCatalogProvisionedProductDetails.ReadOnly
    ] = scala
      .Option(impl.serviceCatalogProvisionedProductDetails())
      .map(value =>
        zio.aws.sagemaker.model.ServiceCatalogProvisionedProductDetails
          .wrap(value)
      )
    override val projectStatus: Option[zio.aws.sagemaker.model.ProjectStatus] =
      scala
        .Option(impl.projectStatus())
        .map(value => zio.aws.sagemaker.model.ProjectStatus.wrap(value))
    override val createdBy
        : Option[zio.aws.sagemaker.model.UserContext.ReadOnly] = scala
      .Option(impl.createdBy())
      .map(value => zio.aws.sagemaker.model.UserContext.wrap(value))
    override val creationTime: Option[Timestamp] = scala
      .Option(impl.creationTime())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val tags: Option[List[zio.aws.sagemaker.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sagemaker.model.Tag.wrap(item)
          }.toList
        )
    override val lastModifiedTime: Option[Timestamp] = scala
      .Option(impl.lastModifiedTime())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val lastModifiedBy
        : Option[zio.aws.sagemaker.model.UserContext.ReadOnly] = scala
      .Option(impl.lastModifiedBy())
      .map(value => zio.aws.sagemaker.model.UserContext.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.Project
  ): zio.aws.sagemaker.model.Project.ReadOnly = new Wrapper(impl)
}
