package zio.aws.sagemaker.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sagemaker.model.primitives.{
  TaskCount,
  VariantWeight,
  VariantName
}
import scala.jdk.CollectionConverters._
final case class ProductionVariantSummary(
    variantName: VariantName,
    deployedImages: Option[Iterable[zio.aws.sagemaker.model.DeployedImage]] =
      None,
    currentWeight: Option[VariantWeight] = None,
    desiredWeight: Option[VariantWeight] = None,
    currentInstanceCount: Option[TaskCount] = None,
    desiredInstanceCount: Option[TaskCount] = None,
    variantStatus: Option[
      Iterable[zio.aws.sagemaker.model.ProductionVariantStatus]
    ] = None,
    currentServerlessConfig: Option[
      zio.aws.sagemaker.model.ProductionVariantServerlessConfig
    ] = None,
    desiredServerlessConfig: Option[
      zio.aws.sagemaker.model.ProductionVariantServerlessConfig
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ProductionVariantSummary = {
    import ProductionVariantSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ProductionVariantSummary
      .builder()
      .variantName(VariantName.unwrap(variantName): java.lang.String)
      .optionallyWith(
        deployedImages.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.deployedImages)
      .optionallyWith(
        currentWeight.map(value => VariantWeight.unwrap(value): java.lang.Float)
      )(_.currentWeight)
      .optionallyWith(
        desiredWeight.map(value => VariantWeight.unwrap(value): java.lang.Float)
      )(_.desiredWeight)
      .optionallyWith(
        currentInstanceCount.map(value => TaskCount.unwrap(value): Integer)
      )(_.currentInstanceCount)
      .optionallyWith(
        desiredInstanceCount.map(value => TaskCount.unwrap(value): Integer)
      )(_.desiredInstanceCount)
      .optionallyWith(
        variantStatus.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.variantStatus)
      .optionallyWith(
        currentServerlessConfig.map(value => value.buildAwsValue())
      )(_.currentServerlessConfig)
      .optionallyWith(
        desiredServerlessConfig.map(value => value.buildAwsValue())
      )(_.desiredServerlessConfig)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.ProductionVariantSummary.ReadOnly =
    zio.aws.sagemaker.model.ProductionVariantSummary.wrap(buildAwsValue())
}
object ProductionVariantSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ProductionVariantSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ProductionVariantSummary =
      zio.aws.sagemaker.model.ProductionVariantSummary(
        variantName,
        deployedImages.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        currentWeight.map(value => value),
        desiredWeight.map(value => value),
        currentInstanceCount.map(value => value),
        desiredInstanceCount.map(value => value),
        variantStatus.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        currentServerlessConfig.map(value => value.asEditable),
        desiredServerlessConfig.map(value => value.asEditable)
      )
    def variantName: VariantName
    def deployedImages
        : Option[List[zio.aws.sagemaker.model.DeployedImage.ReadOnly]]
    def currentWeight: Option[VariantWeight]
    def desiredWeight: Option[VariantWeight]
    def currentInstanceCount: Option[TaskCount]
    def desiredInstanceCount: Option[TaskCount]
    def variantStatus
        : Option[List[zio.aws.sagemaker.model.ProductionVariantStatus.ReadOnly]]
    def currentServerlessConfig: Option[
      zio.aws.sagemaker.model.ProductionVariantServerlessConfig.ReadOnly
    ]
    def desiredServerlessConfig: Option[
      zio.aws.sagemaker.model.ProductionVariantServerlessConfig.ReadOnly
    ]
    def getVariantName: ZIO[Any, Nothing, VariantName] =
      ZIO.succeed(variantName)
    def getDeployedImages: ZIO[Any, AwsError, List[
      zio.aws.sagemaker.model.DeployedImage.ReadOnly
    ]] = AwsError.unwrapOptionField("deployedImages", deployedImages)
    def getCurrentWeight: ZIO[Any, AwsError, VariantWeight] =
      AwsError.unwrapOptionField("currentWeight", currentWeight)
    def getDesiredWeight: ZIO[Any, AwsError, VariantWeight] =
      AwsError.unwrapOptionField("desiredWeight", desiredWeight)
    def getCurrentInstanceCount: ZIO[Any, AwsError, TaskCount] =
      AwsError.unwrapOptionField("currentInstanceCount", currentInstanceCount)
    def getDesiredInstanceCount: ZIO[Any, AwsError, TaskCount] =
      AwsError.unwrapOptionField("desiredInstanceCount", desiredInstanceCount)
    def getVariantStatus: ZIO[Any, AwsError, List[
      zio.aws.sagemaker.model.ProductionVariantStatus.ReadOnly
    ]] = AwsError.unwrapOptionField("variantStatus", variantStatus)
    def getCurrentServerlessConfig: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.ProductionVariantServerlessConfig.ReadOnly
    ] = AwsError.unwrapOptionField(
      "currentServerlessConfig",
      currentServerlessConfig
    )
    def getDesiredServerlessConfig: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.ProductionVariantServerlessConfig.ReadOnly
    ] = AwsError.unwrapOptionField(
      "desiredServerlessConfig",
      desiredServerlessConfig
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ProductionVariantSummary
  ) extends zio.aws.sagemaker.model.ProductionVariantSummary.ReadOnly {
    override val variantName: VariantName =
      zio.aws.sagemaker.model.primitives.VariantName(impl.variantName())
    override val deployedImages
        : Option[List[zio.aws.sagemaker.model.DeployedImage.ReadOnly]] = scala
      .Option(impl.deployedImages())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.sagemaker.model.DeployedImage.wrap(item)
        }.toList
      )
    override val currentWeight: Option[VariantWeight] = scala
      .Option(impl.currentWeight())
      .map(value => zio.aws.sagemaker.model.primitives.VariantWeight(value))
    override val desiredWeight: Option[VariantWeight] = scala
      .Option(impl.desiredWeight())
      .map(value => zio.aws.sagemaker.model.primitives.VariantWeight(value))
    override val currentInstanceCount: Option[TaskCount] = scala
      .Option(impl.currentInstanceCount())
      .map(value => zio.aws.sagemaker.model.primitives.TaskCount(value))
    override val desiredInstanceCount: Option[TaskCount] = scala
      .Option(impl.desiredInstanceCount())
      .map(value => zio.aws.sagemaker.model.primitives.TaskCount(value))
    override val variantStatus: Option[
      List[zio.aws.sagemaker.model.ProductionVariantStatus.ReadOnly]
    ] = scala
      .Option(impl.variantStatus())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.sagemaker.model.ProductionVariantStatus.wrap(item)
        }.toList
      )
    override val currentServerlessConfig: Option[
      zio.aws.sagemaker.model.ProductionVariantServerlessConfig.ReadOnly
    ] = scala
      .Option(impl.currentServerlessConfig())
      .map(value =>
        zio.aws.sagemaker.model.ProductionVariantServerlessConfig.wrap(value)
      )
    override val desiredServerlessConfig: Option[
      zio.aws.sagemaker.model.ProductionVariantServerlessConfig.ReadOnly
    ] = scala
      .Option(impl.desiredServerlessConfig())
      .map(value =>
        zio.aws.sagemaker.model.ProductionVariantServerlessConfig.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ProductionVariantSummary
  ): zio.aws.sagemaker.model.ProductionVariantSummary.ReadOnly = new Wrapper(
    impl
  )
}
