package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.sagemaker.model.primitives.{
  RoleArn,
  PipelineDescription,
  Timestamp,
  PipelineArn,
  PipelineName
}
import scala.jdk.CollectionConverters._
final case class Pipeline(
    pipelineArn: Option[PipelineArn] = None,
    pipelineName: Option[PipelineName] = None,
    pipelineDisplayName: Option[PipelineName] = None,
    pipelineDescription: Option[PipelineDescription] = None,
    roleArn: Option[RoleArn] = None,
    pipelineStatus: Option[zio.aws.sagemaker.model.PipelineStatus] = None,
    creationTime: Option[Timestamp] = None,
    lastModifiedTime: Option[Timestamp] = None,
    lastRunTime: Option[Timestamp] = None,
    createdBy: Option[zio.aws.sagemaker.model.UserContext] = None,
    lastModifiedBy: Option[zio.aws.sagemaker.model.UserContext] = None,
    parallelismConfiguration: Option[
      zio.aws.sagemaker.model.ParallelismConfiguration
    ] = None,
    tags: Option[Iterable[zio.aws.sagemaker.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.Pipeline = {
    import Pipeline.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.Pipeline
      .builder()
      .optionallyWith(
        pipelineArn.map(value => PipelineArn.unwrap(value): java.lang.String)
      )(_.pipelineArn)
      .optionallyWith(
        pipelineName.map(value => PipelineName.unwrap(value): java.lang.String)
      )(_.pipelineName)
      .optionallyWith(
        pipelineDisplayName.map(value =>
          PipelineName.unwrap(value): java.lang.String
        )
      )(_.pipelineDisplayName)
      .optionallyWith(
        pipelineDescription.map(value =>
          PipelineDescription.unwrap(value): java.lang.String
        )
      )(_.pipelineDescription)
      .optionallyWith(
        roleArn.map(value => RoleArn.unwrap(value): java.lang.String)
      )(_.roleArn)
      .optionallyWith(pipelineStatus.map(value => value.unwrap))(
        _.pipelineStatus
      )
      .optionallyWith(
        creationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(
        lastModifiedTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastModifiedTime)
      .optionallyWith(
        lastRunTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastRunTime)
      .optionallyWith(createdBy.map(value => value.buildAwsValue()))(
        _.createdBy
      )
      .optionallyWith(lastModifiedBy.map(value => value.buildAwsValue()))(
        _.lastModifiedBy
      )
      .optionallyWith(
        parallelismConfiguration.map(value => value.buildAwsValue())
      )(_.parallelismConfiguration)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.Pipeline.ReadOnly =
    zio.aws.sagemaker.model.Pipeline.wrap(buildAwsValue())
}
object Pipeline {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.Pipeline
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.Pipeline =
      zio.aws.sagemaker.model.Pipeline(
        pipelineArn.map(value => value),
        pipelineName.map(value => value),
        pipelineDisplayName.map(value => value),
        pipelineDescription.map(value => value),
        roleArn.map(value => value),
        pipelineStatus.map(value => value),
        creationTime.map(value => value),
        lastModifiedTime.map(value => value),
        lastRunTime.map(value => value),
        createdBy.map(value => value.asEditable),
        lastModifiedBy.map(value => value.asEditable),
        parallelismConfiguration.map(value => value.asEditable),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def pipelineArn: Option[PipelineArn]
    def pipelineName: Option[PipelineName]
    def pipelineDisplayName: Option[PipelineName]
    def pipelineDescription: Option[PipelineDescription]
    def roleArn: Option[RoleArn]
    def pipelineStatus: Option[zio.aws.sagemaker.model.PipelineStatus]
    def creationTime: Option[Timestamp]
    def lastModifiedTime: Option[Timestamp]
    def lastRunTime: Option[Timestamp]
    def createdBy: Option[zio.aws.sagemaker.model.UserContext.ReadOnly]
    def lastModifiedBy: Option[zio.aws.sagemaker.model.UserContext.ReadOnly]
    def parallelismConfiguration
        : Option[zio.aws.sagemaker.model.ParallelismConfiguration.ReadOnly]
    def tags: Option[List[zio.aws.sagemaker.model.Tag.ReadOnly]]
    def getPipelineArn: ZIO[Any, AwsError, PipelineArn] =
      AwsError.unwrapOptionField("pipelineArn", pipelineArn)
    def getPipelineName: ZIO[Any, AwsError, PipelineName] =
      AwsError.unwrapOptionField("pipelineName", pipelineName)
    def getPipelineDisplayName: ZIO[Any, AwsError, PipelineName] =
      AwsError.unwrapOptionField("pipelineDisplayName", pipelineDisplayName)
    def getPipelineDescription: ZIO[Any, AwsError, PipelineDescription] =
      AwsError.unwrapOptionField("pipelineDescription", pipelineDescription)
    def getRoleArn: ZIO[Any, AwsError, RoleArn] =
      AwsError.unwrapOptionField("roleArn", roleArn)
    def getPipelineStatus
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.PipelineStatus] =
      AwsError.unwrapOptionField("pipelineStatus", pipelineStatus)
    def getCreationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getLastModifiedTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastModifiedTime", lastModifiedTime)
    def getLastRunTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastRunTime", lastRunTime)
    def getCreatedBy
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.UserContext.ReadOnly] =
      AwsError.unwrapOptionField("createdBy", createdBy)
    def getLastModifiedBy
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.UserContext.ReadOnly] =
      AwsError.unwrapOptionField("lastModifiedBy", lastModifiedBy)
    def getParallelismConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.ParallelismConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "parallelismConfiguration",
      parallelismConfiguration
    )
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.sagemaker.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.Pipeline
  ) extends zio.aws.sagemaker.model.Pipeline.ReadOnly {
    override val pipelineArn: Option[PipelineArn] = scala
      .Option(impl.pipelineArn())
      .map(value => zio.aws.sagemaker.model.primitives.PipelineArn(value))
    override val pipelineName: Option[PipelineName] = scala
      .Option(impl.pipelineName())
      .map(value => zio.aws.sagemaker.model.primitives.PipelineName(value))
    override val pipelineDisplayName: Option[PipelineName] = scala
      .Option(impl.pipelineDisplayName())
      .map(value => zio.aws.sagemaker.model.primitives.PipelineName(value))
    override val pipelineDescription: Option[PipelineDescription] = scala
      .Option(impl.pipelineDescription())
      .map(value =>
        zio.aws.sagemaker.model.primitives.PipelineDescription(value)
      )
    override val roleArn: Option[RoleArn] = scala
      .Option(impl.roleArn())
      .map(value => zio.aws.sagemaker.model.primitives.RoleArn(value))
    override val pipelineStatus
        : Option[zio.aws.sagemaker.model.PipelineStatus] = scala
      .Option(impl.pipelineStatus())
      .map(value => zio.aws.sagemaker.model.PipelineStatus.wrap(value))
    override val creationTime: Option[Timestamp] = scala
      .Option(impl.creationTime())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val lastModifiedTime: Option[Timestamp] = scala
      .Option(impl.lastModifiedTime())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val lastRunTime: Option[Timestamp] = scala
      .Option(impl.lastRunTime())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val createdBy
        : Option[zio.aws.sagemaker.model.UserContext.ReadOnly] = scala
      .Option(impl.createdBy())
      .map(value => zio.aws.sagemaker.model.UserContext.wrap(value))
    override val lastModifiedBy
        : Option[zio.aws.sagemaker.model.UserContext.ReadOnly] = scala
      .Option(impl.lastModifiedBy())
      .map(value => zio.aws.sagemaker.model.UserContext.wrap(value))
    override val parallelismConfiguration
        : Option[zio.aws.sagemaker.model.ParallelismConfiguration.ReadOnly] =
      scala
        .Option(impl.parallelismConfiguration())
        .map(value =>
          zio.aws.sagemaker.model.ParallelismConfiguration.wrap(value)
        )
    override val tags: Option[List[zio.aws.sagemaker.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sagemaker.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.Pipeline
  ): zio.aws.sagemaker.model.Pipeline.ReadOnly = new Wrapper(impl)
}
