package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.sagemaker.model.primitives.{
  CreationTime,
  EntityDescription,
  ModelPackageGroupArn,
  EntityName
}
import scala.jdk.CollectionConverters._
final case class ModelPackageGroup(
    modelPackageGroupName: Option[EntityName] = None,
    modelPackageGroupArn: Option[ModelPackageGroupArn] = None,
    modelPackageGroupDescription: Option[EntityDescription] = None,
    creationTime: Option[CreationTime] = None,
    createdBy: Option[zio.aws.sagemaker.model.UserContext] = None,
    modelPackageGroupStatus: Option[
      zio.aws.sagemaker.model.ModelPackageGroupStatus
    ] = None,
    tags: Option[Iterable[zio.aws.sagemaker.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ModelPackageGroup = {
    import ModelPackageGroup.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ModelPackageGroup
      .builder()
      .optionallyWith(
        modelPackageGroupName.map(value =>
          EntityName.unwrap(value): java.lang.String
        )
      )(_.modelPackageGroupName)
      .optionallyWith(
        modelPackageGroupArn.map(value =>
          ModelPackageGroupArn.unwrap(value): java.lang.String
        )
      )(_.modelPackageGroupArn)
      .optionallyWith(
        modelPackageGroupDescription.map(value =>
          EntityDescription.unwrap(value): java.lang.String
        )
      )(_.modelPackageGroupDescription)
      .optionallyWith(
        creationTime.map(value => CreationTime.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(createdBy.map(value => value.buildAwsValue()))(
        _.createdBy
      )
      .optionallyWith(modelPackageGroupStatus.map(value => value.unwrap))(
        _.modelPackageGroupStatus
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.ModelPackageGroup.ReadOnly =
    zio.aws.sagemaker.model.ModelPackageGroup.wrap(buildAwsValue())
}
object ModelPackageGroup {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ModelPackageGroup
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ModelPackageGroup =
      zio.aws.sagemaker.model.ModelPackageGroup(
        modelPackageGroupName.map(value => value),
        modelPackageGroupArn.map(value => value),
        modelPackageGroupDescription.map(value => value),
        creationTime.map(value => value),
        createdBy.map(value => value.asEditable),
        modelPackageGroupStatus.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def modelPackageGroupName: Option[EntityName]
    def modelPackageGroupArn: Option[ModelPackageGroupArn]
    def modelPackageGroupDescription: Option[EntityDescription]
    def creationTime: Option[CreationTime]
    def createdBy: Option[zio.aws.sagemaker.model.UserContext.ReadOnly]
    def modelPackageGroupStatus
        : Option[zio.aws.sagemaker.model.ModelPackageGroupStatus]
    def tags: Option[List[zio.aws.sagemaker.model.Tag.ReadOnly]]
    def getModelPackageGroupName: ZIO[Any, AwsError, EntityName] =
      AwsError.unwrapOptionField("modelPackageGroupName", modelPackageGroupName)
    def getModelPackageGroupArn: ZIO[Any, AwsError, ModelPackageGroupArn] =
      AwsError.unwrapOptionField("modelPackageGroupArn", modelPackageGroupArn)
    def getModelPackageGroupDescription: ZIO[Any, AwsError, EntityDescription] =
      AwsError.unwrapOptionField(
        "modelPackageGroupDescription",
        modelPackageGroupDescription
      )
    def getCreationTime: ZIO[Any, AwsError, CreationTime] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getCreatedBy
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.UserContext.ReadOnly] =
      AwsError.unwrapOptionField("createdBy", createdBy)
    def getModelPackageGroupStatus
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.ModelPackageGroupStatus] =
      AwsError.unwrapOptionField(
        "modelPackageGroupStatus",
        modelPackageGroupStatus
      )
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.sagemaker.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ModelPackageGroup
  ) extends zio.aws.sagemaker.model.ModelPackageGroup.ReadOnly {
    override val modelPackageGroupName: Option[EntityName] = scala
      .Option(impl.modelPackageGroupName())
      .map(value => zio.aws.sagemaker.model.primitives.EntityName(value))
    override val modelPackageGroupArn: Option[ModelPackageGroupArn] = scala
      .Option(impl.modelPackageGroupArn())
      .map(value =>
        zio.aws.sagemaker.model.primitives.ModelPackageGroupArn(value)
      )
    override val modelPackageGroupDescription: Option[EntityDescription] = scala
      .Option(impl.modelPackageGroupDescription())
      .map(value => zio.aws.sagemaker.model.primitives.EntityDescription(value))
    override val creationTime: Option[CreationTime] = scala
      .Option(impl.creationTime())
      .map(value => zio.aws.sagemaker.model.primitives.CreationTime(value))
    override val createdBy
        : Option[zio.aws.sagemaker.model.UserContext.ReadOnly] = scala
      .Option(impl.createdBy())
      .map(value => zio.aws.sagemaker.model.UserContext.wrap(value))
    override val modelPackageGroupStatus
        : Option[zio.aws.sagemaker.model.ModelPackageGroupStatus] = scala
      .Option(impl.modelPackageGroupStatus())
      .map(value => zio.aws.sagemaker.model.ModelPackageGroupStatus.wrap(value))
    override val tags: Option[List[zio.aws.sagemaker.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sagemaker.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ModelPackageGroup
  ): zio.aws.sagemaker.model.ModelPackageGroup.ReadOnly = new Wrapper(impl)
}
