package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ModelMetadataSearchExpression(
    filters: Option[Iterable[zio.aws.sagemaker.model.ModelMetadataFilter]] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ModelMetadataSearchExpression = {
    import ModelMetadataSearchExpression.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ModelMetadataSearchExpression
      .builder()
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.ModelMetadataSearchExpression.ReadOnly =
    zio.aws.sagemaker.model.ModelMetadataSearchExpression.wrap(buildAwsValue())
}
object ModelMetadataSearchExpression {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ModelMetadataSearchExpression
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ModelMetadataSearchExpression =
      zio.aws.sagemaker.model.ModelMetadataSearchExpression(
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def filters
        : Option[List[zio.aws.sagemaker.model.ModelMetadataFilter.ReadOnly]]
    def getFilters: ZIO[Any, AwsError, List[
      zio.aws.sagemaker.model.ModelMetadataFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("filters", filters)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ModelMetadataSearchExpression
  ) extends zio.aws.sagemaker.model.ModelMetadataSearchExpression.ReadOnly {
    override val filters
        : Option[List[zio.aws.sagemaker.model.ModelMetadataFilter.ReadOnly]] =
      scala
        .Option(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sagemaker.model.ModelMetadataFilter.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ModelMetadataSearchExpression
  ): zio.aws.sagemaker.model.ModelMetadataSearchExpression.ReadOnly =
    new Wrapper(impl)
}
