package zio.aws.sagemaker.model
import zio.aws.sagemaker.model.primitives.{
  EntityName,
  Timestamp,
  ListMaxResults,
  NextToken
}
import java.time.Instant
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListDevicesRequest(
    nextToken: Option[NextToken] = None,
    maxResults: Option[ListMaxResults] = None,
    latestHeartbeatAfter: Option[Timestamp] = None,
    modelName: Option[EntityName] = None,
    deviceFleetName: Option[EntityName] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ListDevicesRequest = {
    import ListDevicesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ListDevicesRequest
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => ListMaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        latestHeartbeatAfter.map(value => Timestamp.unwrap(value): Instant)
      )(_.latestHeartbeatAfter)
      .optionallyWith(
        modelName.map(value => EntityName.unwrap(value): java.lang.String)
      )(_.modelName)
      .optionallyWith(
        deviceFleetName.map(value => EntityName.unwrap(value): java.lang.String)
      )(_.deviceFleetName)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.ListDevicesRequest.ReadOnly =
    zio.aws.sagemaker.model.ListDevicesRequest.wrap(buildAwsValue())
}
object ListDevicesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ListDevicesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ListDevicesRequest =
      zio.aws.sagemaker.model.ListDevicesRequest(
        nextToken.map(value => value),
        maxResults.map(value => value),
        latestHeartbeatAfter.map(value => value),
        modelName.map(value => value),
        deviceFleetName.map(value => value)
      )
    def nextToken: Option[NextToken]
    def maxResults: Option[ListMaxResults]
    def latestHeartbeatAfter: Option[Timestamp]
    def modelName: Option[EntityName]
    def deviceFleetName: Option[EntityName]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, ListMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getLatestHeartbeatAfter: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("latestHeartbeatAfter", latestHeartbeatAfter)
    def getModelName: ZIO[Any, AwsError, EntityName] =
      AwsError.unwrapOptionField("modelName", modelName)
    def getDeviceFleetName: ZIO[Any, AwsError, EntityName] =
      AwsError.unwrapOptionField("deviceFleetName", deviceFleetName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ListDevicesRequest
  ) extends zio.aws.sagemaker.model.ListDevicesRequest.ReadOnly {
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.sagemaker.model.primitives.NextToken(value))
    override val maxResults: Option[ListMaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.sagemaker.model.primitives.ListMaxResults(value))
    override val latestHeartbeatAfter: Option[Timestamp] = scala
      .Option(impl.latestHeartbeatAfter())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val modelName: Option[EntityName] = scala
      .Option(impl.modelName())
      .map(value => zio.aws.sagemaker.model.primitives.EntityName(value))
    override val deviceFleetName: Option[EntityName] = scala
      .Option(impl.deviceFleetName())
      .map(value => zio.aws.sagemaker.model.primitives.EntityName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ListDevicesRequest
  ): zio.aws.sagemaker.model.ListDevicesRequest.ReadOnly = new Wrapper(impl)
}
