package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class LabelingJobDataAttributes(
    contentClassifiers: Option[
      Iterable[zio.aws.sagemaker.model.ContentClassifier]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.LabelingJobDataAttributes = {
    import LabelingJobDataAttributes.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.LabelingJobDataAttributes
      .builder()
      .optionallyWith(
        contentClassifiers.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.contentClassifiersWithStrings)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.LabelingJobDataAttributes.ReadOnly =
    zio.aws.sagemaker.model.LabelingJobDataAttributes.wrap(buildAwsValue())
}
object LabelingJobDataAttributes {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.LabelingJobDataAttributes
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.LabelingJobDataAttributes =
      zio.aws.sagemaker.model
        .LabelingJobDataAttributes(contentClassifiers.map(value => value))
    def contentClassifiers
        : Option[List[zio.aws.sagemaker.model.ContentClassifier]]
    def getContentClassifiers
        : ZIO[Any, AwsError, List[zio.aws.sagemaker.model.ContentClassifier]] =
      AwsError.unwrapOptionField("contentClassifiers", contentClassifiers)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.LabelingJobDataAttributes
  ) extends zio.aws.sagemaker.model.LabelingJobDataAttributes.ReadOnly {
    override val contentClassifiers
        : Option[List[zio.aws.sagemaker.model.ContentClassifier]] = scala
      .Option(impl.contentClassifiers())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.sagemaker.model.ContentClassifier.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.LabelingJobDataAttributes
  ): zio.aws.sagemaker.model.LabelingJobDataAttributes.ReadOnly = new Wrapper(
    impl
  )
}
